/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.visitors.data;

import io.github.skylot.raung.disasm.impl.utils.ListUtils;
import io.github.skylot.raung.disasm.impl.visitors.data.LocalVar;
import io.github.skylot.raung.disasm.impl.visitors.data.TryCatchBlock;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;

public class LabelData {
    private final Label label;
    private final String name;
    private int insnRef;
    private int useCount;
    @Nullable
    private List<LocalVar> startVars;
    @Nullable
    private List<LocalVar> endVars;
    @Nullable
    private List<TryCatchBlock> catches;
    @Nullable
    private List<Integer> lines;

    public LabelData(Label label, String name) {
        this.label = label;
        this.name = name;
    }

    public Label getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public int getInsnRef() {
        return this.insnRef;
    }

    public void setInsnRef(int insnRef) {
        this.insnRef = insnRef;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public LabelData addUse() {
        ++this.useCount;
        return this;
    }

    public List<LocalVar> getStartVars() {
        return ListUtils.fromNullable(this.startVars);
    }

    public void addStartVars(LocalVar var) {
        this.startVars = ListUtils.addToNullable(this.startVars, var);
    }

    public List<LocalVar> getEndVars() {
        return ListUtils.fromNullable(this.endVars);
    }

    public void addEndVar(LocalVar var) {
        this.endVars = ListUtils.addToNullable(this.endVars, var);
    }

    public List<TryCatchBlock> getCatches() {
        return ListUtils.fromNullable(this.catches);
    }

    public void addCatch(TryCatchBlock block) {
        this.catches = ListUtils.addToNullable(this.catches, block);
    }

    public List<Integer> getLines() {
        return ListUtils.fromNullable(this.lines);
    }

    public void setLine(int line) {
        this.lines = ListUtils.addToNullable(this.lines, line);
    }

    public String toString() {
        return this.name + " at " + this.insnRef;
    }
}

