/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.utils;

import io.github.skylot.raung.common.asm.TypeRef;
import io.github.skylot.raung.disasm.impl.utils.RaungDisasmException;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRefUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TypeRefUtils.class);

    public static String formatPath(int typeRef, TypePath typePath) {
        TypeReference typeReference = new TypeReference(typeRef);
        int sort = typeReference.getSort();
        TypeRef raungTypeRef = TypeRef.getByValue(sort);
        if (raungTypeRef == null) {
            String sortStr = TypeRefUtils.rawSortFormat(typeReference, sort);
            LOG.warn("TODO: Missing type reference info: {}", (Object)sortStr);
            return sortStr;
        }
        StringBuilder sb5 = new StringBuilder(raungTypeRef.getName());
        TypeRefUtils.appendArgs(raungTypeRef, typeReference, sb5);
        if (typePath != null) {
            sb5.append(' ').append(typePath);
        }
        return sb5.toString();
    }

    private static void appendArgs(TypeRef refType, TypeReference ref, StringBuilder sb5) {
        switch (refType.getFormat()) {
            case NO_ARGS: {
                break;
            }
            case TYPE_PARAM_INDEX: {
                sb5.append(' ').append(ref.getTypeParameterIndex());
                break;
            }
            case TYPE_PARAM_BOUND_INDEX: {
                sb5.append(' ').append(ref.getTypeParameterIndex()).append(' ').append(ref.getTypeParameterBoundIndex());
                break;
            }
            case SUPER_TYPE_INDEX: {
                sb5.append(' ').append(ref.getSuperTypeIndex());
                break;
            }
            case FORMAL_PARAM_INDEX: {
                sb5.append(' ').append(ref.getFormalParameterIndex());
                break;
            }
            case EXCEPTION_INDEX: {
                sb5.append(' ').append(ref.getExceptionIndex());
                break;
            }
            case TRY_CATCH_BLOCK_INDEX: {
                sb5.append(' ').append(ref.getTryCatchBlockIndex());
                break;
            }
            case TYPE_ARGUMENT_INDEX: {
                sb5.append(' ').append(ref.getTypeArgumentIndex());
                break;
            }
            default: {
                throw new RaungDisasmException("Unsupported type reference sort: " + refType);
            }
        }
    }

    @Deprecated
    private static String rawSortFormat(TypeReference typeReference, int sort) {
        switch (sort) {
            case 0: {
                return "CLASS_TYPE_PARAMETER " + typeReference.getTypeParameterIndex();
            }
            case 1: {
                return "METHOD_TYPE_PARAMETER " + typeReference.getTypeParameterIndex();
            }
            case 16: {
                return "CLASS_EXTENDS " + typeReference.getSuperTypeIndex();
            }
            case 17: {
                return "CLASS_TYPE_PARAMETER_BOUND " + typeReference.getTypeParameterIndex() + " " + typeReference.getTypeParameterBoundIndex();
            }
            case 18: {
                return "METHOD_TYPE_PARAMETER_BOUND " + typeReference.getTypeParameterIndex() + " " + typeReference.getTypeParameterBoundIndex();
            }
            case 19: {
                return "FIELD";
            }
            case 20: {
                return "METHOD_RETURN";
            }
            case 21: {
                return "METHOD_RECEIVER";
            }
            case 22: {
                return "METHOD_FORMAL_PARAMETER " + typeReference.getFormalParameterIndex();
            }
            case 23: {
                return "THROWS " + typeReference.getExceptionIndex();
            }
            case 64: {
                return "LOCAL_VARIABLE";
            }
            case 65: {
                return "RESOURCE_VARIABLE";
            }
            case 66: {
                return "EXCEPTION_PARAMETER " + typeReference.getTryCatchBlockIndex();
            }
            case 67: {
                return "INSTANCEOF";
            }
            case 68: {
                return "NEW";
            }
            case 69: {
                return "CONSTRUCTOR_REFERENCE";
            }
            case 70: {
                return "METHOD_REFERENCE";
            }
            case 71: {
                return "CAST " + typeReference.getTypeArgumentIndex();
            }
            case 72: {
                return "CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT " + typeReference.getTypeArgumentIndex();
            }
            case 73: {
                return "METHOD_INVOCATION_TYPE_ARGUMENT " + typeReference.getTypeArgumentIndex();
            }
            case 74: {
                return "CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT " + typeReference.getTypeArgumentIndex();
            }
            case 75: {
                return "METHOD_REFERENCE_TYPE_ARGUMENT " + typeReference.getTypeArgumentIndex();
            }
        }
        throw new RaungDisasmException("Unexpected type reference sort: " + sort);
    }
}

