/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private final long maxSize;
    private long currentPos;

    protected LimitedInputStream(InputStream in4, long maxSize) {
        super(in4);
        this.maxSize = maxSize;
    }

    private void checkPos() {
        if (this.currentPos > this.maxSize) {
            throw new IllegalStateException("Read limit exceeded");
        }
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        if (data != -1) {
            ++this.currentPos;
            this.checkPos();
        }
        return data;
    }

    @Override
    public int read(byte[] b15, int off, int len) throws IOException {
        int count = super.read(b15, off, len);
        if (count > 0) {
            this.currentPos += (long)count;
            this.checkPos();
        }
        return count;
    }

    @Override
    public long skip(long n15) throws IOException {
        long skipped = super.skip(n15);
        if (skipped != 0L) {
            this.currentPos += skipped;
            this.checkPos();
        }
        return skipped;
    }
}

