/*
 * Decompiled with CFR 0.152.
 */
package hu.kazocsaba.imageviewer;

import hu.kazocsaba.imageviewer.ImageComponent;
import hu.kazocsaba.imageviewer.Overlay;
import hu.kazocsaba.imageviewer.OverlayComponent;
import hu.kazocsaba.imageviewer.ResizeStrategy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

class LayeredImageView {
    private final ImageComponent theImage;
    private final JLayeredPane layeredPane;

    public LayeredImageView(ImageComponent theImage) {
        this.theImage = theImage;
        this.layeredPane = new ScrollableLayeredPane();
        this.layeredPane.setLayout(new OverlayLayout());
        this.layeredPane.add((Component)theImage, (Object)0);
        this.layeredPane.setOpaque(true);
    }

    public JComponent getComponent() {
        return this.layeredPane;
    }

    public void addOverlay(Overlay overlay, int layer) {
        if (overlay == null) {
            throw new NullPointerException();
        }
        OverlayComponent c15 = new OverlayComponent(overlay, this.theImage);
        overlay.addOverlayComponent(c15);
        this.layeredPane.add((Component)c15, (Object)layer);
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    public void removeOverlay(Overlay overlay) {
        if (overlay == null) {
            throw new NullPointerException();
        }
        for (Component c15 : this.layeredPane.getComponents()) {
            if (!(c15 instanceof OverlayComponent) || ((OverlayComponent)c15).overlay != overlay) continue;
            overlay.removeOverlayComponent((OverlayComponent)c15);
            this.layeredPane.remove(c15);
            this.layeredPane.revalidate();
            this.layeredPane.repaint();
            return;
        }
        throw new IllegalArgumentException("Overlay not part of this viewer");
    }

    private class ScrollableLayeredPane
    extends JLayeredPane
    implements Scrollable {
        private ScrollableLayeredPane() {
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 50;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return LayeredImageView.this.theImage.getResizeStrategy() == ResizeStrategy.SHRINK_TO_FIT || LayeredImageView.this.theImage.getResizeStrategy() == ResizeStrategy.RESIZE_TO_FIT;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return LayeredImageView.this.theImage.getResizeStrategy() == ResizeStrategy.SHRINK_TO_FIT || LayeredImageView.this.theImage.getResizeStrategy() == ResizeStrategy.RESIZE_TO_FIT;
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            if (LayeredImageView.this.theImage.getResizeStrategy() == ResizeStrategy.NO_RESIZE) {
                return this.getPreferredSize();
            }
            return ((JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this)).getSize();
        }
    }

    private class OverlayLayout
    implements LayoutManager {
        private OverlayLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return LayeredImageView.this.theImage.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return LayeredImageView.this.theImage.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            for (int i15 = 0; i15 < parent.getComponentCount(); ++i15) {
                parent.getComponent(i15).setBounds(0, 0, parent.getWidth(), parent.getHeight());
            }
        }
    }
}

