/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.swing;

import hu.akarnokd.rxjava3.swing.AbstractEventConsumer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;

final class WindowEventObservable
extends Observable<WindowEvent> {
    final Window widget;
    final int flags;

    WindowEventObservable(Window widget, int flags) {
        this.widget = widget;
        this.flags = flags;
    }

    @Override
    protected void subscribeActual(Observer<? super WindowEvent> observer) {
        Window w15 = this.widget;
        int f15 = this.flags;
        WindowEventConsumer aec = new WindowEventConsumer(observer, w15, f15);
        observer.onSubscribe(aec);
        if ((f15 & 1) != 0) {
            w15.addWindowListener(aec);
        }
        if ((f15 & 2) != 0) {
            w15.addWindowFocusListener(aec);
        }
        if ((f15 & 4) != 0) {
            w15.addWindowStateListener(aec);
        }
        if (aec.get() == null) {
            aec.onDispose(w15);
        }
    }

    static final class WindowEventConsumer
    extends AbstractEventConsumer<WindowEvent, Window>
    implements WindowListener,
    WindowFocusListener,
    WindowStateListener {
        private static final long serialVersionUID = -3605206827474016488L;
        final int flags;

        WindowEventConsumer(Observer<? super WindowEvent> actual, Window widget, int flags) {
            super(actual, widget);
            this.flags = flags;
        }

        @Override
        protected void onDispose(Window w15) {
            int f15 = this.flags;
            if ((f15 & 1) != 0) {
                w15.removeWindowListener(this);
            }
            if ((f15 & 2) != 0) {
                w15.removeWindowFocusListener(this);
            }
            if ((f15 & 4) != 0) {
                w15.removeWindowStateListener(this);
            }
        }

        @Override
        public void windowStateChanged(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowGainedFocus(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowLostFocus(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowOpened(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowClosing(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowClosed(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowIconified(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowDeiconified(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowActivated(WindowEvent e15) {
            this.actual.onNext(e15);
        }

        @Override
        public void windowDeactivated(WindowEvent e15) {
            this.actual.onNext(e15);
        }
    }
}

