/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.swing;

import hu.akarnokd.rxjava3.swing.RxSwingPlugins;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Timer;

final class AsyncSwingScheduler
extends Scheduler {
    static final Scheduler INSTANCE = new AsyncSwingScheduler();

    AsyncSwingScheduler() {
    }

    @Override
    public Disposable scheduleDirect(Runnable run) {
        DirectTask dt4 = new DirectTask(RxSwingPlugins.onSchedule(run));
        EventQueue.invokeLater(dt4);
        return dt4;
    }

    @Override
    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        DirectTimedTask dtt = new DirectTimedTask(RxSwingPlugins.onSchedule(run), (int)unit.toMillis(delay), (int)Math.max(0L, unit.toMillis(delay)), false);
        dtt.start();
        return dtt;
    }

    @Override
    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        DirectTimedTask dtt = new DirectTimedTask(RxSwingPlugins.onSchedule(run), (int)unit.toMillis(initialDelay), (int)Math.max(0L, unit.toMillis(period)), true);
        dtt.start();
        return dtt;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new AsyncSwingWorker();
    }

    static final class DirectTimedTask
    extends Timer
    implements ActionListener,
    Disposable {
        private static final long serialVersionUID = 1146820542834025296L;
        final boolean periodic;
        Runnable run;

        DirectTimedTask(Runnable run, int initialDelayMillis, int periodMillis, boolean periodic) {
            super(0, null);
            this.run = run;
            this.periodic = periodic;
            this.setInitialDelay(initialDelayMillis);
            this.setDelay(periodMillis);
            this.addActionListener(this);
        }

        @Override
        public void dispose() {
            this.run = null;
            this.stop();
        }

        @Override
        public boolean isDisposed() {
            return this.run == null;
        }

        @Override
        public void actionPerformed(ActionEvent e15) {
            Runnable r15 = this.run;
            if (r15 != null) {
                try {
                    r15.run();
                }
                catch (Throwable ex4) {
                    this.run = null;
                    this.stop();
                    Exceptions.throwIfFatal(ex4);
                    RxJavaPlugins.onError(ex4);
                    return;
                }
                if (!this.periodic) {
                    this.run = null;
                    this.stop();
                }
            }
        }
    }

    static final class DirectTask
    extends AtomicReference<Runnable>
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = -4645934389976373118L;

        DirectTask(Runnable run) {
            this.lazySet(run);
        }

        @Override
        public void run() {
            Runnable r15 = this.getAndSet(null);
            if (r15 != null) {
                try {
                    r15.run();
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    RxJavaPlugins.onError(ex4);
                }
            }
        }

        @Override
        public void dispose() {
            this.getAndSet(null);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }

    static final class AsyncSwingWorker
    extends Scheduler.Worker {
        CompositeDisposable tasks = new CompositeDisposable();

        AsyncSwingWorker() {
        }

        @Override
        public void dispose() {
            this.tasks.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.tasks.isDisposed();
        }

        void remove(Disposable d15) {
            this.tasks.delete(d15);
        }

        boolean add(Disposable d15) {
            return this.tasks.add(d15);
        }

        @Override
        public Disposable schedule(Runnable run) {
            WorkerTask wt4 = new WorkerTask(RxSwingPlugins.onSchedule(run));
            if (this.add(wt4)) {
                EventQueue.invokeLater(wt4);
                return wt4;
            }
            return EmptyDisposable.INSTANCE;
        }

        @Override
        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            WorkerTimedTask wtt = new WorkerTimedTask(RxSwingPlugins.onSchedule(run), (int)unit.toMillis(delay), (int)Math.max(0L, unit.toMillis(delay)), false);
            if (this.add(wtt)) {
                wtt.start();
                return wtt;
            }
            return EmptyDisposable.INSTANCE;
        }

        @Override
        public Disposable schedulePeriodically(Runnable run, long initialDelay, long period, TimeUnit unit) {
            WorkerTimedTask wtt = new WorkerTimedTask(RxSwingPlugins.onSchedule(run), (int)unit.toMillis(initialDelay), (int)Math.max(0L, unit.toMillis(period)), true);
            if (this.add(wtt)) {
                wtt.start();
                return wtt;
            }
            return EmptyDisposable.INSTANCE;
        }

        final class WorkerTimedTask
        extends Timer
        implements ActionListener,
        Disposable {
            private static final long serialVersionUID = 1146820542834025296L;
            final boolean periodic;
            Runnable run;

            WorkerTimedTask(Runnable run, int initialDelayMillis, int periodMillis, boolean periodic) {
                super(0, null);
                this.run = run;
                this.periodic = periodic;
                this.setInitialDelay(initialDelayMillis);
                this.setDelay(periodMillis);
                this.addActionListener(this);
            }

            @Override
            public void dispose() {
                this.run = null;
                this.stop();
                AsyncSwingWorker.this.remove(this);
            }

            @Override
            public boolean isDisposed() {
                return this.run == null;
            }

            @Override
            public void actionPerformed(ActionEvent e15) {
                Runnable r15 = this.run;
                if (r15 != null) {
                    try {
                        r15.run();
                    }
                    catch (Throwable ex4) {
                        this.run = null;
                        this.stop();
                        AsyncSwingWorker.this.remove(this);
                        Exceptions.throwIfFatal(ex4);
                        RxJavaPlugins.onError(ex4);
                        return;
                    }
                    if (!this.periodic) {
                        this.run = null;
                        this.stop();
                        AsyncSwingWorker.this.remove(this);
                    }
                }
            }
        }

        final class WorkerTask
        extends AtomicReference<Runnable>
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = 3954858753004137205L;

            WorkerTask(Runnable run) {
                this.lazySet(run);
            }

            @Override
            public void dispose() {
                if (this.getAndSet(null) != null) {
                    AsyncSwingWorker.this.remove(this);
                }
            }

            @Override
            public boolean isDisposed() {
                return this.get() == null;
            }

            @Override
            public void run() {
                Runnable r15 = this.getAndSet(null);
                if (r15 != null) {
                    try {
                        r15.run();
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        RxJavaPlugins.onError(ex4);
                    }
                    AsyncSwingWorker.this.remove(this);
                }
            }
        }
    }
}

