/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.Seekable;
import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.SeekableOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public abstract class RandomAccessStream
implements Seekable,
DataInput,
DataOutput {
    SeekableInputStream inputView = null;
    SeekableOutputStream outputView = null;

    public int read() throws IOException {
        try {
            return this.readByte() & 0xFF;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n15, int n16) throws IOException {
        int n17;
        if (byArray == null) {
            throw new NullPointerException("bytes == null");
        }
        if (n15 < 0 || n15 > byArray.length || n16 < 0 || n15 + n16 > byArray.length || n15 + n16 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n16 == 0) {
            return 0;
        }
        int n18 = this.read();
        if (n18 == -1) {
            return -1;
        }
        byArray[n15] = (byte)n18;
        try {
            for (n17 = 1; n17 < n16 && (n18 = this.read()) != -1; ++n17) {
                byArray[n15 + n17] = (byte)n18;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n17;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray != null ? byArray.length : 1);
    }

    public final SeekableInputStream asInputStream() {
        if (this.inputView == null) {
            this.inputView = new InputStreamView(this);
        }
        return this.inputView;
    }

    public final SeekableOutputStream asOutputStream() {
        if (this.outputView == null) {
            this.outputView = new OutputStreamView(this);
        }
        return this.outputView;
    }

    static final class OutputStreamView
    extends SeekableOutputStream {
        private final RandomAccessStream mStream;

        public OutputStreamView(RandomAccessStream randomAccessStream) {
            if (randomAccessStream == null) {
                throw new IllegalArgumentException("stream == null");
            }
            this.mStream = randomAccessStream;
        }

        @Override
        public boolean isCached() {
            return this.mStream.isCached();
        }

        @Override
        public boolean isCachedFile() {
            return this.mStream.isCachedFile();
        }

        @Override
        public boolean isCachedMemory() {
            return this.mStream.isCachedMemory();
        }

        @Override
        protected void closeImpl() throws IOException {
            this.mStream.close();
        }

        @Override
        protected void flushBeforeImpl(long l15) throws IOException {
            this.mStream.flushBefore(l15);
        }

        @Override
        protected void seekImpl(long l15) throws IOException {
            this.mStream.seek(l15);
        }

        @Override
        public void write(int n15) throws IOException {
            this.mStream.write(n15);
        }

        @Override
        public void write(byte[] byArray, int n15, int n16) throws IOException {
            this.mStream.write(byArray, n15, n16);
        }
    }

    static final class InputStreamView
    extends SeekableInputStream {
        private final RandomAccessStream mStream;

        public InputStreamView(RandomAccessStream randomAccessStream) {
            if (randomAccessStream == null) {
                throw new IllegalArgumentException("stream == null");
            }
            this.mStream = randomAccessStream;
        }

        @Override
        public boolean isCached() {
            return this.mStream.isCached();
        }

        @Override
        public boolean isCachedFile() {
            return this.mStream.isCachedFile();
        }

        @Override
        public boolean isCachedMemory() {
            return this.mStream.isCachedMemory();
        }

        @Override
        protected void closeImpl() throws IOException {
            this.mStream.close();
        }

        @Override
        protected void flushBeforeImpl(long l15) throws IOException {
            this.mStream.flushBefore(l15);
        }

        @Override
        protected void seekImpl(long l15) throws IOException {
            this.mStream.seek(l15);
        }

        @Override
        public int read() throws IOException {
            return this.mStream.read();
        }

        @Override
        public int read(byte[] byArray, int n15, int n16) throws IOException {
            return this.mStream.read(byArray, n15, n16);
        }
    }
}

