/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.AppendableWriter;
import com.google.common.io.Java8Compatibility;
import com.google.common.io.LineProcessor;
import com.google.common.io.LineReader;
import com.google.common.io.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

@J2ktIncompatible
@GwtIncompatible
public final class CharStreams {
    private static final int DEFAULT_BUF_SIZE = 2048;

    static CharBuffer createBuffer() {
        return CharBuffer.allocate(2048);
    }

    private CharStreams() {
    }

    @CanIgnoreReturnValue
    public static long copy(Readable from, Appendable to4) throws IOException {
        if (from instanceof Reader) {
            if (to4 instanceof StringBuilder) {
                return CharStreams.copyReaderToBuilder((Reader)from, (StringBuilder)to4);
            }
            return CharStreams.copyReaderToWriter((Reader)from, CharStreams.asWriter(to4));
        }
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to4);
        long total = 0L;
        CharBuffer buf = CharStreams.createBuffer();
        while (from.read(buf) != -1) {
            Java8Compatibility.flip(buf);
            to4.append(buf);
            total += (long)buf.remaining();
            Java8Compatibility.clear(buf);
        }
        return total;
    }

    @CanIgnoreReturnValue
    static long copyReaderToBuilder(Reader from, StringBuilder to4) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to4);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from.read(buf)) != -1) {
            to4.append(buf, 0, nRead);
            total += (long)nRead;
        }
        return total;
    }

    @CanIgnoreReturnValue
    static long copyReaderToWriter(Reader from, Writer to4) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to4);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from.read(buf)) != -1) {
            to4.write(buf, 0, nRead);
            total += (long)nRead;
        }
        return total;
    }

    public static String toString(Readable r15) throws IOException {
        return CharStreams.toStringBuilder(r15).toString();
    }

    private static StringBuilder toStringBuilder(Readable r15) throws IOException {
        StringBuilder sb5 = new StringBuilder();
        if (r15 instanceof Reader) {
            CharStreams.copyReaderToBuilder((Reader)r15, sb5);
        } else {
            CharStreams.copy(r15, sb5);
        }
        return sb5;
    }

    public static List<String> readLines(Readable r15) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        LineReader lineReader = new LineReader(r15);
        while ((line = lineReader.readLine()) != null) {
            result.add(line);
        }
        return result;
    }

    @CanIgnoreReturnValue
    @ParametricNullness
    public static <T> T readLines(Readable readable, LineProcessor<T> processor) throws IOException {
        String line;
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(processor);
        LineReader lineReader = new LineReader(readable);
        while ((line = lineReader.readLine()) != null && processor.processLine(line)) {
        }
        return processor.getResult();
    }

    @CanIgnoreReturnValue
    public static long exhaust(Readable readable) throws IOException {
        long read;
        long total = 0L;
        CharBuffer buf = CharStreams.createBuffer();
        while ((read = (long)readable.read(buf)) != -1L) {
            total += read;
            Java8Compatibility.clear(buf);
        }
        return total;
    }

    public static void skipFully(Reader reader, long n15) throws IOException {
        Preconditions.checkNotNull(reader);
        while (n15 > 0L) {
            long amt = reader.skip(n15);
            if (amt == 0L) {
                throw new EOFException();
            }
            n15 -= amt;
        }
    }

    public static Writer nullWriter() {
        return NullWriter.INSTANCE;
    }

    public static Writer asWriter(Appendable target) {
        if (target instanceof Writer) {
            return (Writer)target;
        }
        return new AppendableWriter(target);
    }

    private static final class NullWriter
    extends Writer {
        private static final NullWriter INSTANCE = new NullWriter();

        private NullWriter() {
        }

        @Override
        public void write(int c15) {
        }

        @Override
        public void write(char[] cbuf) {
            Preconditions.checkNotNull(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            Preconditions.checkPositionIndexes(off, off + len, cbuf.length);
        }

        @Override
        public void write(String str) {
            Preconditions.checkNotNull(str);
        }

        @Override
        public void write(String str, int off, int len) {
            Preconditions.checkPositionIndexes(off, off + len, str.length());
        }

        @Override
        public Writer append(@Nullable CharSequence csq) {
            return this;
        }

        @Override
        public Writer append(@Nullable CharSequence csq, int start, int end) {
            Preconditions.checkPositionIndexes(start, end, csq == null ? "null".length() : csq.length());
            return this;
        }

        @Override
        public Writer append(char c15) {
            return this;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "CharStreams.nullWriter()";
        }
    }
}

