/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.LexicographicalOrdering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.TopKSelector;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import org.jspecify.annotations.Nullable;

@GwtCompatible
public final class Comparators {
    private Comparators() {
    }

    public static <T, S extends T> Comparator<Iterable<S>> lexicographical(Comparator<T> comparator) {
        return new LexicographicalOrdering<T>(Preconditions.checkNotNull(comparator));
    }

    public static <T> boolean isInOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (comparator.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public static <T> boolean isInStrictOrder(Iterable<? extends T> iterable, Comparator<T> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (comparator.compare(prev, next) >= 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public static <T> Collector<T, ?, List<T>> least(int k15, Comparator<? super T> comparator) {
        CollectPreconditions.checkNonnegative(k15, "k");
        Preconditions.checkNotNull(comparator);
        return Collector.of(() -> TopKSelector.least(k15, comparator), TopKSelector::offer, TopKSelector::combine, TopKSelector::topK, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ?, List<T>> greatest(int k15, Comparator<? super T> comparator) {
        return Comparators.least(k15, comparator.reversed());
    }

    public static <T> Comparator<Optional<T>> emptiesFirst(Comparator<? super T> valueComparator) {
        Preconditions.checkNotNull(valueComparator);
        return Comparator.comparing(o15 -> Comparators.orElseNull(o15), Comparator.nullsFirst(valueComparator));
    }

    public static <T> Comparator<Optional<T>> emptiesLast(Comparator<? super T> valueComparator) {
        Preconditions.checkNotNull(valueComparator);
        return Comparator.comparing(o15 -> Comparators.orElseNull(o15), Comparator.nullsLast(valueComparator));
    }

    private static <T> @Nullable T orElseNull(Optional<T> optional) {
        return optional.orElse(null);
    }

    public static <T extends Comparable<? super T>> T min(T a15, T b15) {
        return a15.compareTo(b15) <= 0 ? a15 : b15;
    }

    @ParametricNullness
    public static <T> T min(@ParametricNullness T a15, @ParametricNullness T b15, Comparator<? super T> comparator) {
        return comparator.compare(a15, b15) <= 0 ? a15 : b15;
    }

    public static <T extends Comparable<? super T>> T max(T a15, T b15) {
        return a15.compareTo(b15) >= 0 ? a15 : b15;
    }

    @ParametricNullness
    public static <T> T max(@ParametricNullness T a15, @ParametricNullness T b15, Comparator<? super T> comparator) {
        return comparator.compare(a15, b15) >= 0 ? a15 : b15;
    }
}

