/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FlatTableHeaderUI
extends BasicTableHeaderUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color hoverBackground;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color pressedBackground;
    @FlatStylingSupport.Styleable
    protected Color pressedForeground;
    @FlatStylingSupport.Styleable
    protected Color bottomSeparatorColor;
    @FlatStylingSupport.Styleable
    protected int height;
    @FlatStylingSupport.Styleable(type=String.class)
    protected int sortIconPosition;
    @FlatStylingSupport.Styleable
    protected Insets cellMargins;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    @FlatStylingSupport.Styleable
    protected Boolean showTrailingVerticalLine;
    @FlatStylingSupport.Styleable
    public String arrowType;
    @FlatStylingSupport.Styleable
    public Color sortIconColor;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatTableHeaderUI();
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.header.remove(this.rendererPane);
        this.rendererPane = new FlatTableHeaderCellRendererPane();
        this.header.add(this.rendererPane);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.hoverBackground = UIManager.getColor("TableHeader.hoverBackground");
        this.hoverForeground = UIManager.getColor("TableHeader.hoverForeground");
        this.pressedBackground = UIManager.getColor("TableHeader.pressedBackground");
        this.pressedForeground = UIManager.getColor("TableHeader.pressedForeground");
        this.bottomSeparatorColor = UIManager.getColor("TableHeader.bottomSeparatorColor");
        this.height = UIManager.getInt("TableHeader.height");
        this.sortIconPosition = FlatTableHeaderUI.parseSortIconPosition(UIManager.getString("TableHeader.sortIconPosition"));
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverBackground = null;
        this.hoverForeground = null;
        this.pressedBackground = null;
        this.pressedForeground = null;
        this.bottomSeparatorColor = null;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = FlatStylingSupport.createPropertyChangeListener(this.header, this::installStyle, null);
        this.header.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.header.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.header, "TableHeader"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        if (key.equals("sortIconPosition") && value instanceof String) {
            value = FlatTableHeaderUI.parseSortIconPosition((String)value);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.header, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        if (key.equals("sortIconPosition")) {
            switch (this.sortIconPosition) {
                default: {
                    return "right";
                }
                case 2: {
                    return "left";
                }
                case 1: {
                    return "top";
                }
                case 3: 
            }
            return "bottom";
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    private static int parseSortIconPosition(String str) {
        if (str == null) {
            str = "";
        }
        switch (str) {
            default: {
                return 4;
            }
            case "left": {
                return 2;
            }
            case "top": {
                return 1;
            }
            case "bottom": 
        }
        return 3;
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new FlatMouseInputHandler();
    }

    @Override
    public int getRolloverColumn() {
        return super.getRolloverColumn();
    }

    @Override
    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
        HiDPIUtils.repaint(this.header, this.header.getHeaderRect(oldColumn));
        HiDPIUtils.repaint(this.header, this.header.getHeaderRect(newColumn));
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        FlatTableHeaderUI.fixDraggedAndResizingColumns(this.header);
        TableColumnModel columnModel = this.header.getColumnModel();
        if (columnModel.getColumnCount() <= 0) {
            return;
        }
        int columnCount = columnModel.getColumnCount();
        int totalWidth = 0;
        for (int i15 = 0; i15 < columnCount; ++i15) {
            totalWidth += columnModel.getColumn(i15).getWidth();
        }
        if (totalWidth < this.header.getWidth()) {
            TableCellRenderer defaultRenderer = this.header.getDefaultRenderer();
            boolean paintBottomSeparator = this.isSystemDefaultRenderer(defaultRenderer);
            if (!paintBottomSeparator && this.header.getTable() != null) {
                Component rendererComponent = defaultRenderer.getTableCellRendererComponent(this.header.getTable(), "", false, false, -1, 0);
                paintBottomSeparator = this.isSystemDefaultRenderer(rendererComponent);
            }
            if (paintBottomSeparator) {
                int w15 = c15.getWidth() - totalWidth;
                int x15 = this.header.getComponentOrientation().isLeftToRight() ? c15.getWidth() - w15 : 0;
                this.paintBottomSeparator(g15, c15, x15, w15);
            }
        }
        super.paint(g15, c15);
    }

    private boolean isSystemDefaultRenderer(Object headerRenderer) {
        String rendererClassName = headerRenderer.getClass().getName();
        return rendererClassName.equals("sun.swing.table.DefaultTableCellHeaderRenderer") || rendererClassName.equals("sun.swing.FilePane$AlignableTableHeaderRenderer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBottomSeparator(Graphics g15, JComponent c15, int x15, int w15) {
        float lineWidth = UIScale.scale(1.0f);
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            FlatUIUtils.setRenderingHints(g25);
            g25.setColor(this.bottomSeparatorColor);
            g25.fill(new Rectangle2D.Float(x15, (float)c15.getHeight() - lineWidth, w15, lineWidth));
        }
        finally {
            g25.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        Dimension size = super.getPreferredSize(c15);
        if (size.height > 0) {
            size.height = Math.max(size.height, UIScale.scale(this.height));
        }
        return size;
    }

    static void fixDraggedAndResizingColumns(JTableHeader header) {
        TableColumn resizingColumn;
        if (header == null) {
            return;
        }
        TableColumn draggedColumn = header.getDraggedColumn();
        if (draggedColumn != null && !FlatTableHeaderUI.isValidColumn(header.getColumnModel(), draggedColumn)) {
            header.setDraggedColumn(null);
        }
        if ((resizingColumn = header.getResizingColumn()) != null && !FlatTableHeaderUI.isValidColumn(header.getColumnModel(), resizingColumn)) {
            header.setResizingColumn(null);
        }
    }

    private static boolean isValidColumn(TableColumnModel cm4, TableColumn column) {
        int count = cm4.getColumnCount();
        for (int i15 = 0; i15 < count; ++i15) {
            if (cm4.getColumn(i15) != column) continue;
            return true;
        }
        return false;
    }

    protected class FlatMouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        Cursor oldCursor;

        protected FlatMouseInputHandler() {
            super(FlatTableHeaderUI.this);
        }

        @Override
        public void mouseMoved(MouseEvent e15) {
            int column;
            JTable table;
            if (this.oldCursor != null) {
                FlatTableHeaderUI.this.header.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
            super.mouseMoved(e15);
            if (FlatTableHeaderUI.this.header.isEnabled() && (table = FlatTableHeaderUI.this.header.getTable()) != null && table.getAutoResizeMode() != 0 && FlatTableHeaderUI.this.header.getCursor() == Cursor.getPredefinedCursor(11) && (column = FlatTableHeaderUI.this.header.columnAtPoint(e15.getPoint())) >= 0 && column == FlatTableHeaderUI.this.header.getColumnModel().getColumnCount() - 1) {
                Rectangle r15 = FlatTableHeaderUI.this.header.getHeaderRect(column);
                r15.grow(-3, 0);
                if (!r15.contains(e15.getX(), e15.getY())) {
                    boolean isResizeLastColumn;
                    boolean bl4 = isResizeLastColumn = e15.getX() >= r15.x + r15.width / 2;
                    if (!FlatTableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                        boolean bl5 = isResizeLastColumn = !isResizeLastColumn;
                    }
                    if (isResizeLastColumn) {
                        this.oldCursor = FlatTableHeaderUI.this.header.getCursor();
                        FlatTableHeaderUI.this.header.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        }
    }

    private class FlatTableHeaderCellRendererPane
    extends CellRendererPane {
        private final Icon ascendingSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
        private final Icon descendingSortIcon = UIManager.getIcon("Table.descendingSortIcon");

        @Override
        public void paintComponent(Graphics g15, Component c15, Container p15, int x15, int y15, int w15, int h15, boolean shouldValidate) {
            Icon icon;
            boolean isSortIcon;
            if (!(c15 instanceof JLabel)) {
                super.paintComponent(g15, c15, p15, x15, y15, w15, h15, shouldValidate);
                return;
            }
            JLabel l15 = (JLabel)c15;
            Color oldBackground = null;
            Color oldForeground = null;
            boolean oldOpaque = false;
            Icon oldIcon = null;
            int oldHorizontalTextPosition = -1;
            TableColumn draggedColumn = FlatTableHeaderUI.this.header.getDraggedColumn();
            Color background = null;
            Color foreground = null;
            if (draggedColumn != null && FlatTableHeaderUI.this.header.getTable().convertColumnIndexToView(draggedColumn.getModelIndex()) == this.getColumn(x15 - FlatTableHeaderUI.this.header.getDraggedDistance(), w15)) {
                background = FlatTableHeaderUI.this.pressedBackground;
                foreground = FlatTableHeaderUI.this.pressedForeground;
            } else if (FlatTableHeaderUI.this.getRolloverColumn() >= 0 && FlatTableHeaderUI.this.getRolloverColumn() == this.getColumn(x15, w15)) {
                background = FlatTableHeaderUI.this.hoverBackground;
                foreground = FlatTableHeaderUI.this.hoverForeground;
            }
            if (background != null) {
                oldBackground = l15.getBackground();
                oldOpaque = l15.isOpaque();
                l15.setBackground(FlatUIUtils.deriveColor(background, FlatTableHeaderUI.this.header.getBackground()));
                l15.setOpaque(true);
            }
            if (foreground != null) {
                oldForeground = l15.getForeground();
                l15.setForeground(FlatUIUtils.deriveColor(foreground, FlatTableHeaderUI.this.header.getForeground()));
            }
            boolean bl4 = isSortIcon = (icon = l15.getIcon()) != null && (icon == this.ascendingSortIcon || icon == this.descendingSortIcon);
            if (isSortIcon) {
                if (FlatTableHeaderUI.this.sortIconPosition == 2) {
                    oldHorizontalTextPosition = l15.getHorizontalTextPosition();
                    l15.setHorizontalTextPosition(4);
                } else if (FlatTableHeaderUI.this.sortIconPosition == 1 || FlatTableHeaderUI.this.sortIconPosition == 3) {
                    oldIcon = icon;
                    l15.setIcon(null);
                }
            }
            super.paintComponent(g15, c15, p15, x15, y15, w15, h15, shouldValidate);
            if (isSortIcon && (FlatTableHeaderUI.this.sortIconPosition == 1 || FlatTableHeaderUI.this.sortIconPosition == 3)) {
                int xi4 = x15 + (w15 - icon.getIconWidth()) / 2;
                int yi4 = FlatTableHeaderUI.this.sortIconPosition == 1 ? y15 + UIScale.scale(1) : y15 + FlatTableHeaderUI.this.height - icon.getIconHeight() - 1 - (int)(1.0f * UIScale.getUserScaleFactor());
                icon.paintIcon(c15, g15, xi4, yi4);
            }
            if (background != null) {
                l15.setBackground(oldBackground);
                l15.setOpaque(oldOpaque);
            }
            if (foreground != null) {
                l15.setForeground(oldForeground);
            }
            if (oldIcon != null) {
                l15.setIcon(oldIcon);
            }
            if (oldHorizontalTextPosition >= 0) {
                l15.setHorizontalTextPosition(oldHorizontalTextPosition);
            }
        }

        private int getColumn(int x15, int width) {
            TableColumnModel columnModel = FlatTableHeaderUI.this.header.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            boolean ltr = FlatTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            int cx4 = ltr ? 0 : this.getWidthInRightToLef();
            for (int i15 = 0; i15 < columnCount; ++i15) {
                int cw4 = columnModel.getColumn(i15).getWidth();
                if (x15 == cx4 - (ltr ? 0 : cw4) && width == cw4) {
                    return i15;
                }
                cx4 += ltr ? cw4 : -cw4;
            }
            return -1;
        }

        private int getWidthInRightToLef() {
            JTable table = FlatTableHeaderUI.this.header.getTable();
            return table != null && table.getAutoResizeMode() != 0 ? table.getWidth() : FlatTableHeaderUI.this.header.getWidth();
        }
    }
}

