/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.fonts.inter;

import com.formdev.flatlaf.util.FontUtils;

public class FlatInterFont {
    public static final String FAMILY = "Inter";
    public static final String FAMILY_LIGHT = "Inter Light";
    public static final String FAMILY_SEMIBOLD = "Inter SemiBold";
    public static final String STYLE_REGULAR = "Inter-Regular.otf";
    public static final String STYLE_ITALIC = "Inter-Italic.otf";
    public static final String STYLE_BOLD = "Inter-Bold.otf";
    public static final String STYLE_BOLD_ITALIC = "Inter-BoldItalic.otf";
    public static final String STYLE_LIGHT = "Inter-Light.otf";
    public static final String STYLE_LIGHT_ITALIC = "Inter-LightItalic.otf";
    public static final String STYLE_SEMIBOLD = "Inter-SemiBold.otf";
    public static final String STYLE_SEMIBOLD_ITALIC = "Inter-SemiBoldItalic.otf";

    private FlatInterFont() {
    }

    public static void installLazy() {
        FontUtils.registerFontFamilyLoader(FAMILY, FlatInterFont::installBasic);
        FontUtils.registerFontFamilyLoader(FAMILY_LIGHT, FlatInterFont::installLight);
        FontUtils.registerFontFamilyLoader(FAMILY_SEMIBOLD, FlatInterFont::installSemiBold);
    }

    public static void install() {
        FlatInterFont.installBasic();
        FlatInterFont.installLight();
        FlatInterFont.installSemiBold();
    }

    public static void installBasic() {
        FlatInterFont.installStyle(STYLE_REGULAR);
        FlatInterFont.installStyle(STYLE_ITALIC);
        FlatInterFont.installStyle(STYLE_BOLD);
        FlatInterFont.installStyle(STYLE_BOLD_ITALIC);
    }

    public static void installLight() {
        FlatInterFont.installStyle(STYLE_LIGHT);
        FlatInterFont.installStyle(STYLE_LIGHT_ITALIC);
    }

    public static void installSemiBold() {
        FlatInterFont.installStyle(STYLE_SEMIBOLD);
        FlatInterFont.installStyle(STYLE_SEMIBOLD_ITALIC);
    }

    public static boolean installStyle(String name) {
        return FontUtils.installFont(FlatInterFont.class.getResource(name));
    }
}

