/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.Maps;
import java.util.Map;

public class FuzzyMap {
    public static <V> V findInMap(Map<? extends IKey, V> map, IKey name, boolean caseSensitive, boolean allowAbbreviations) {
        if (allowAbbreviations) {
            return FuzzyMap.findAbbreviatedValue(map, name, caseSensitive);
        }
        if (caseSensitive) {
            return map.get(name);
        }
        for (IKey iKey : map.keySet()) {
            if (!iKey.getName().equalsIgnoreCase(name.getName())) continue;
            return map.get(iKey);
        }
        return null;
    }

    private static <V> V findAbbreviatedValue(Map<? extends IKey, V> map, IKey name, boolean caseSensitive) {
        String string = name.getName();
        Map<String, V> results = Maps.newHashMap();
        for (IKey iKey : map.keySet()) {
            String n15 = iKey.getName();
            boolean match = caseSensitive && n15.startsWith(string) || !caseSensitive && n15.toLowerCase().startsWith(string.toLowerCase());
            if (!match) continue;
            results.put(n15, map.get(iKey));
        }
        if (results.size() > 1) {
            throw new ParameterException("Ambiguous option: " + name + " matches " + results.keySet());
        }
        V result = results.size() == 1 ? (V)results.values().iterator().next() : null;
        return result;
    }

    static interface IKey {
        public String getName();
    }
}

