/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.android.tools.smali.util.ExceptionWithContext;
import com.android.tools.smali.util.PathUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassFileNameHandler {
    private static final int MAX_FILENAME_LENGTH = 255;
    private static final int NUMERIC_SUFFIX_RESERVE = 6;
    private final int NO_VALUE = -1;
    private final int CASE_INSENSITIVE = 0;
    private final int CASE_SENSITIVE = 1;
    private int forcedCaseSensitivity = -1;
    private DirectoryEntry top;
    private String fileExtension;
    private boolean modifyWindowsReservedFilenames;
    private static Pattern reservedFileNameRegex = Pattern.compile("^(CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(\\..*)?$", 2);

    public ClassFileNameHandler(File path, String fileExtension) {
        this.top = new DirectoryEntry(path);
        this.fileExtension = fileExtension;
        this.modifyWindowsReservedFilenames = ClassFileNameHandler.isWindows();
    }

    public ClassFileNameHandler(File path, String fileExtension, boolean caseSensitive, boolean modifyWindowsReservedFilenames) {
        this.top = new DirectoryEntry(path);
        this.fileExtension = fileExtension;
        this.forcedCaseSensitivity = caseSensitive ? 1 : 0;
        this.modifyWindowsReservedFilenames = modifyWindowsReservedFilenames;
    }

    private int getMaxFilenameLength() {
        return 249;
    }

    public File getUniqueFilenameForClass(String className) throws IOException {
        if (className.charAt(0) != 'L' || className.charAt(className.length() - 1) != ';') {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        int packageElementCount = 1;
        for (int i15 = 1; i15 < className.length() - 1; ++i15) {
            if (className.charAt(i15) != '/') continue;
            ++packageElementCount;
        }
        String[] packageElements = new String[packageElementCount];
        int elementIndex = 0;
        int elementStart = 1;
        for (int i16 = 1; i16 < className.length() - 1; ++i16) {
            if (className.charAt(i16) != '/') continue;
            if (i16 - elementStart == 0) {
                throw new RuntimeException("Not a valid dalvik class name");
            }
            packageElements[elementIndex++] = className.substring(elementStart, i16);
            elementStart = ++i16;
        }
        if (elementStart >= className.length() - 1) {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        packageElements[elementIndex] = className.substring(elementStart, className.length() - 1);
        return this.addUniqueChild(this.top, packageElements, 0);
    }

    @Nonnull
    private File addUniqueChild(@Nonnull DirectoryEntry parent, @Nonnull String[] packageElements, int packageElementIndex) throws IOException {
        if (packageElementIndex == packageElements.length - 1) {
            FileEntry fileEntry = new FileEntry(parent, packageElements[packageElementIndex] + this.fileExtension);
            parent.addChild(fileEntry);
            String physicalName = fileEntry.getPhysicalName();
            assert (physicalName != null);
            return new File(parent.file, physicalName);
        }
        DirectoryEntry directoryEntry = new DirectoryEntry(parent, packageElements[packageElementIndex]);
        directoryEntry = (DirectoryEntry)parent.addChild(directoryEntry);
        return this.addUniqueChild(directoryEntry, packageElements, packageElementIndex + 1);
    }

    private static int utf8Length(String str) {
        int c15;
        int utf8Length = 0;
        for (int i15 = 0; i15 < str.length(); i15 += Character.charCount(c15)) {
            c15 = str.codePointAt(i15);
            utf8Length += ClassFileNameHandler.utf8Length(c15);
        }
        return utf8Length;
    }

    private static int utf8Length(int codePoint) {
        if (codePoint < 128) {
            return 1;
        }
        if (codePoint < 2048) {
            return 2;
        }
        if (codePoint < 65536) {
            return 3;
        }
        return 4;
    }

    @Nonnull
    static String shortenPathComponent(@Nonnull String pathComponent, int bytesToRemove) {
        int i15;
        int midPoint;
        int[] codePoints;
        ++bytesToRemove;
        try {
            IntBuffer intBuffer = ByteBuffer.wrap(pathComponent.getBytes("UTF-32BE")).asIntBuffer();
            codePoints = new int[intBuffer.limit()];
            intBuffer.get(codePoints);
        }
        catch (UnsupportedEncodingException ex4) {
            throw new RuntimeException(ex4);
        }
        int firstEnd = midPoint = codePoints.length / 2;
        int secondStart = midPoint + 1;
        int bytesRemoved = ClassFileNameHandler.utf8Length(codePoints[midPoint]);
        if (codePoints.length % 2 == 0 && bytesRemoved < bytesToRemove) {
            bytesRemoved += ClassFileNameHandler.utf8Length(codePoints[secondStart]);
            ++secondStart;
        }
        while (bytesRemoved < bytesToRemove && (firstEnd > 0 || secondStart < codePoints.length)) {
            if (firstEnd > 0) {
                bytesRemoved += ClassFileNameHandler.utf8Length(codePoints[--firstEnd]);
            }
            if (bytesRemoved >= bytesToRemove || secondStart >= codePoints.length) continue;
            bytesRemoved += ClassFileNameHandler.utf8Length(codePoints[secondStart]);
            ++secondStart;
        }
        StringBuilder sb5 = new StringBuilder();
        for (i15 = 0; i15 < firstEnd; ++i15) {
            sb5.appendCodePoint(codePoints[i15]);
        }
        sb5.append('#');
        for (i15 = secondStart; i15 < codePoints.length; ++i15) {
            sb5.appendCodePoint(codePoints[i15]);
        }
        return sb5.toString();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static boolean isReservedFileName(String className) {
        return reservedFileNameRegex.matcher(className).matches();
    }

    private static String addSuffixBeforeExtension(String pathElement, String suffix) {
        int extensionStart = pathElement.lastIndexOf(46);
        StringBuilder newName = new StringBuilder(pathElement.length() + suffix.length() + 1);
        if (extensionStart < 0) {
            newName.append(pathElement);
            newName.append(suffix);
        } else {
            newName.append(pathElement.subSequence(0, extensionStart));
            newName.append(suffix);
            newName.append(pathElement.subSequence(extensionStart, pathElement.length()));
        }
        return newName.toString();
    }

    private class FileEntry
    extends FileSystemEntry {
        private FileEntry(@Nonnull DirectoryEntry parent, String logicalName) {
            super(parent, logicalName);
        }

        @Override
        public String getPhysicalNameWithSuffix(int suffix) {
            if (suffix > 0) {
                return ClassFileNameHandler.addSuffixBeforeExtension(this.getNormalizedName(true), '.' + Integer.toString(suffix));
            }
            return this.getNormalizedName(true);
        }

        @Override
        protected void createIfNeeded() throws IOException {
            String physicalName = this.getPhysicalName();
            if (this.parent != null && physicalName != null) {
                File file2 = new File(this.parent.file, physicalName).getCanonicalFile();
                file2.createNewFile();
            }
        }
    }

    private class DirectoryEntry
    extends FileSystemEntry {
        @Nullable
        private File file;
        private int caseSensitivity;
        private final Multimap<String, FileSystemEntry> children;
        private final Map<String, FileSystemEntry> physicalToEntry;
        private final Map<String, Integer> lastSuffixMap;

        public DirectoryEntry(File path) {
            super(null, path.getName());
            this.file = null;
            this.caseSensitivity = ClassFileNameHandler.this.forcedCaseSensitivity;
            this.children = ArrayListMultimap.create();
            this.physicalToEntry = new HashMap<String, FileSystemEntry>();
            this.lastSuffixMap = new HashMap<String, Integer>();
            this.file = path;
            this.physicalName = this.file.getName();
        }

        public DirectoryEntry(@Nonnull DirectoryEntry parent, String logicalName) {
            super(parent, logicalName);
            this.file = null;
            this.caseSensitivity = ClassFileNameHandler.this.forcedCaseSensitivity;
            this.children = ArrayListMultimap.create();
            this.physicalToEntry = new HashMap<String, FileSystemEntry>();
            this.lastSuffixMap = new HashMap<String, Integer>();
        }

        public synchronized FileSystemEntry addChild(FileSystemEntry entry) throws IOException {
            File entryFile;
            String entryPhysicalName;
            Integer lastSuffix;
            String normalizedChildName = entry.getNormalizedName(false);
            Collection<FileSystemEntry> entries = this.children.get(normalizedChildName);
            if (entry instanceof DirectoryEntry) {
                for (FileSystemEntry childEntry : entries) {
                    if (!childEntry.logicalName.equals(entry.logicalName)) continue;
                    return childEntry;
                }
            }
            if ((lastSuffix = this.lastSuffixMap.get(normalizedChildName)) == null) {
                lastSuffix = -1;
            }
            int suffix = lastSuffix;
            do {
                entryPhysicalName = entry.getPhysicalNameWithSuffix(++suffix);
            } while (this.physicalToEntry.containsKey(entryPhysicalName = (entryFile = new File(this.file, entryPhysicalName)).getCanonicalFile().getName()));
            entry.setSuffix(suffix);
            this.lastSuffixMap.put(normalizedChildName, suffix);
            this.physicalToEntry.put(entry.getPhysicalName(), entry);
            entries.add(entry);
            return entry;
        }

        @Override
        public String getPhysicalNameWithSuffix(int suffix) {
            if (suffix > 0) {
                return this.getNormalizedName(true) + "." + suffix;
            }
            return this.getNormalizedName(true);
        }

        @Override
        protected void createIfNeeded() throws IOException {
            String physicalName = this.getPhysicalName();
            if (this.parent != null && physicalName != null) {
                this.file = new File(this.parent.file, physicalName).getCanonicalFile();
                this.file.mkdirs();
            }
        }

        protected boolean isCaseSensitive() {
            if (this.getPhysicalName() == null || this.file == null) {
                throw new IllegalStateException("Must call setSuffix() first");
            }
            if (this.caseSensitivity != -1) {
                return this.caseSensitivity == 1;
            }
            File path = this.file;
            if (path.exists() && path.isFile() && !path.delete()) {
                throw new ExceptionWithContext("Can't delete %s to make it into a directory", path.getAbsolutePath());
            }
            if (!path.exists() && !path.mkdirs()) {
                throw new ExceptionWithContext("Couldn't create directory %s", path.getAbsolutePath());
            }
            try {
                boolean result = PathUtil.testCaseSensitivity(path);
                this.caseSensitivity = result ? 1 : 0;
                return result;
            }
            catch (IOException ex4) {
                return false;
            }
        }
    }

    private abstract class FileSystemEntry {
        @Nullable
        public final DirectoryEntry parent;
        @Nonnull
        public final String logicalName;
        @Nullable
        protected String physicalName = null;

        private FileSystemEntry(@Nonnull DirectoryEntry parent, String logicalName) {
            this.parent = parent;
            this.logicalName = logicalName;
        }

        @Nonnull
        public String getNormalizedName(boolean preserveCase) {
            int utf8Length;
            String elementName = this.logicalName;
            if (!preserveCase && this.parent != null && !this.parent.isCaseSensitive()) {
                elementName = elementName.toLowerCase();
            }
            if (ClassFileNameHandler.this.modifyWindowsReservedFilenames && ClassFileNameHandler.isReservedFileName(elementName)) {
                elementName = ClassFileNameHandler.addSuffixBeforeExtension(elementName, "#");
            }
            if ((utf8Length = ClassFileNameHandler.utf8Length(elementName)) > ClassFileNameHandler.this.getMaxFilenameLength()) {
                elementName = ClassFileNameHandler.shortenPathComponent(elementName, utf8Length - ClassFileNameHandler.this.getMaxFilenameLength());
            }
            return elementName;
        }

        @Nullable
        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setSuffix(int suffix) throws IOException {
            if (suffix < 0 || suffix > 99999) {
                throw new IllegalArgumentException("suffix must be in [0, 100000)");
            }
            if (this.physicalName != null) {
                throw new IllegalStateException("The suffix can only be set once");
            }
            String physicalName = this.getPhysicalNameWithSuffix(suffix);
            File file2 = new File(this.parent.file, physicalName).getCanonicalFile();
            this.physicalName = file2.getName();
            this.createIfNeeded();
        }

        protected abstract void createIfNeeded() throws IOException;

        public abstract String getPhysicalNameWithSuffix(int var1);
    }
}

