/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.android.tools.build.bundletool.model.exceptions.InvalidDeviceSpecException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.protobuf.Int32Value;
import java.util.stream.Collectors;

public class DeviceTierApkMatcher
extends TargetingDimensionMatcher<Targeting.DeviceTierTargeting> {
    public DeviceTierApkMatcher(Devices.DeviceSpec deviceSpec) {
        super(deviceSpec);
    }

    @Override
    protected Targeting.DeviceTierTargeting getTargetingValue(Targeting.ApkTargeting apkTargeting) {
        return apkTargeting.getDeviceTierTargeting();
    }

    @Override
    protected Targeting.DeviceTierTargeting getTargetingValue(Targeting.VariantTargeting variantTargeting) {
        return Targeting.DeviceTierTargeting.getDefaultInstance();
    }

    @Override
    public boolean matchesTargeting(Targeting.DeviceTierTargeting targeting) {
        if (targeting.equals(Targeting.DeviceTierTargeting.getDefaultInstance())) {
            return true;
        }
        ImmutableSet values2 = targeting.getValueList().stream().map(Int32Value::getValue).collect(ImmutableSet.toImmutableSet());
        ImmutableSet alternatives = targeting.getAlternativesList().stream().map(Int32Value::getValue).collect(ImmutableSet.toImmutableSet());
        Sets.SetView intersection = Sets.intersection(values2, alternatives);
        Preconditions.checkArgument(intersection.isEmpty(), "Expected targeting values and alternatives to be mutually exclusive, but both contain: %s", intersection);
        if (!this.getDeviceSpec().hasDeviceTier()) {
            throw InvalidDeviceSpecException.builder().withUserMessage("The bundle uses device tier targeting, but no device tier was specified.").build();
        }
        return values2.contains(this.getDeviceSpec().getDeviceTier().getValue());
    }

    @Override
    protected boolean isDeviceDimensionPresent() {
        return this.getDeviceSpec().hasDeviceTier();
    }

    @Override
    protected void checkDeviceCompatibleInternal(Targeting.DeviceTierTargeting targeting) {
        if (targeting.equals(Targeting.DeviceTierTargeting.getDefaultInstance())) {
            return;
        }
        ImmutableSet valuesAndAlternatives = Streams.concat(targeting.getValueList().stream().map(Int32Value::getValue), targeting.getAlternativesList().stream().map(Int32Value::getValue)).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument(valuesAndAlternatives.contains(this.getDeviceSpec().getDeviceTier().getValue()), "The specified device tier '%s' does not match any of the available values: %s.", this.getDeviceSpec().getDeviceTier().getValue(), (Object)valuesAndAlternatives.stream().map(i15 -> i15.toString()).collect(Collectors.joining(", ")));
    }
}

