/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.MutabilityControl;
import java.util.Arrays;

public final class IntList
extends MutabilityControl {
    public static final IntList EMPTY = new IntList(0);
    private int[] values;
    private int size;
    private boolean sorted;

    public static IntList makeImmutable(int value) {
        IntList result = new IntList(1);
        result.add(value);
        result.setImmutable();
        return result;
    }

    public static IntList makeImmutable(int value0, int value1) {
        IntList result = new IntList(2);
        result.add(value0);
        result.add(value1);
        result.setImmutable();
        return result;
    }

    public IntList() {
        this(4);
    }

    public IntList(int initialCapacity) {
        super(true);
        try {
            this.values = new int[initialCapacity];
        }
        catch (NegativeArraySizeException ex4) {
            throw new IllegalArgumentException("size < 0");
        }
        this.size = 0;
        this.sorted = true;
    }

    public int hashCode() {
        int result = 0;
        for (int i15 = 0; i15 < this.size; ++i15) {
            result = result * 31 + this.values[i15];
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IntList)) {
            return false;
        }
        IntList otherList = (IntList)other;
        if (this.sorted != otherList.sorted) {
            return false;
        }
        if (this.size != otherList.size) {
            return false;
        }
        for (int i15 = 0; i15 < this.size; ++i15) {
            if (this.values[i15] == otherList.values[i15]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb5 = new StringBuilder(this.size * 5 + 10);
        sb5.append('{');
        for (int i15 = 0; i15 < this.size; ++i15) {
            if (i15 != 0) {
                sb5.append(", ");
            }
            sb5.append(this.values[i15]);
        }
        sb5.append('}');
        return sb5.toString();
    }

    public int size() {
        return this.size;
    }

    public int get(int n15) {
        if (n15 >= this.size) {
            throw new IndexOutOfBoundsException("n >= size()");
        }
        try {
            return this.values[n15];
        }
        catch (ArrayIndexOutOfBoundsException ex4) {
            throw new IndexOutOfBoundsException("n < 0");
        }
    }

    public void set(int n15, int value) {
        block3: {
            this.throwIfImmutable();
            if (n15 >= this.size) {
                throw new IndexOutOfBoundsException("n >= size()");
            }
            try {
                this.values[n15] = value;
                this.sorted = false;
            }
            catch (ArrayIndexOutOfBoundsException ex4) {
                if (n15 >= 0) break block3;
                throw new IllegalArgumentException("n < 0");
            }
        }
    }

    public void add(int value) {
        this.throwIfImmutable();
        this.growIfNeeded();
        this.values[this.size++] = value;
        if (this.sorted && this.size > 1) {
            this.sorted = value >= this.values[this.size - 2];
        }
    }

    public void insert(int n15, int value) {
        if (n15 > this.size) {
            throw new IndexOutOfBoundsException("n > size()");
        }
        this.growIfNeeded();
        System.arraycopy(this.values, n15, this.values, n15 + 1, this.size - n15);
        this.values[n15] = value;
        ++this.size;
        this.sorted = !(!this.sorted || n15 != 0 && value <= this.values[n15 - 1] || n15 != this.size - 1 && value >= this.values[n15 + 1]);
    }

    public void removeIndex(int n15) {
        if (n15 >= this.size) {
            throw new IndexOutOfBoundsException("n >= size()");
        }
        System.arraycopy(this.values, n15 + 1, this.values, n15, this.size - n15 - 1);
        --this.size;
    }

    private void growIfNeeded() {
        if (this.size == this.values.length) {
            int[] newv = new int[this.size * 3 / 2 + 10];
            System.arraycopy(this.values, 0, newv, 0, this.size);
            this.values = newv;
        }
    }

    public int top() {
        return this.get(this.size - 1);
    }

    public int pop() {
        this.throwIfImmutable();
        int result = this.get(this.size - 1);
        --this.size;
        return result;
    }

    public void pop(int n15) {
        this.throwIfImmutable();
        this.size -= n15;
    }

    public void shrink(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize < 0");
        }
        if (newSize > this.size) {
            throw new IllegalArgumentException("newSize > size");
        }
        this.throwIfImmutable();
        this.size = newSize;
    }

    public IntList mutableCopy() {
        int sz4 = this.size;
        IntList result = new IntList(sz4);
        for (int i15 = 0; i15 < sz4; ++i15) {
            result.add(this.values[i15]);
        }
        return result;
    }

    public void sort() {
        this.throwIfImmutable();
        if (!this.sorted) {
            Arrays.sort(this.values, 0, this.size);
            this.sorted = true;
        }
    }

    public int indexOf(int value) {
        int ret = this.binarysearch(value);
        return ret >= 0 ? ret : -1;
    }

    public int binarysearch(int value) {
        int sz4 = this.size;
        if (!this.sorted) {
            for (int i15 = 0; i15 < sz4; ++i15) {
                if (this.values[i15] != value) continue;
                return i15;
            }
            return -sz4;
        }
        int min = -1;
        int max = sz4;
        while (max > min + 1) {
            int guessIdx = min + (max - min >> 1);
            int guess = this.values[guessIdx];
            if (value <= guess) {
                max = guessIdx;
                continue;
            }
            min = guessIdx;
        }
        if (max != sz4) {
            return value == this.values[max] ? max : -max - 1;
        }
        return -sz4 - 1;
    }

    public boolean contains(int value) {
        return this.indexOf(value) >= 0;
    }

    static {
        EMPTY.setImmutable();
    }
}

