/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.util.IntList;

public class BasicRegisterMapper
extends RegisterMapper {
    private final IntList oldToNew;
    private int runningCountNewRegisters;

    public BasicRegisterMapper(int countOldRegisters) {
        this.oldToNew = new IntList(countOldRegisters);
    }

    @Override
    public int getNewRegisterCount() {
        return this.runningCountNewRegisters;
    }

    @Override
    public RegisterSpec map(RegisterSpec registerSpec) {
        int newReg;
        if (registerSpec == null) {
            return null;
        }
        try {
            newReg = this.oldToNew.get(registerSpec.getReg());
        }
        catch (IndexOutOfBoundsException ex4) {
            newReg = -1;
        }
        if (newReg < 0) {
            throw new RuntimeException("no mapping specified for register");
        }
        return registerSpec.withReg(newReg);
    }

    public int oldToNew(int oldReg) {
        if (oldReg >= this.oldToNew.size()) {
            return -1;
        }
        return this.oldToNew.get(oldReg);
    }

    public String toHuman() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append("Old\tNew\n");
        int sz4 = this.oldToNew.size();
        for (int i15 = 0; i15 < sz4; ++i15) {
            sb5.append(i15);
            sb5.append('\t');
            sb5.append(this.oldToNew.get(i15));
            sb5.append('\n');
        }
        sb5.append("new reg count:");
        sb5.append(this.runningCountNewRegisters);
        sb5.append('\n');
        return sb5.toString();
    }

    public void addMapping(int oldReg, int newReg, int category) {
        if (oldReg >= this.oldToNew.size()) {
            for (int i15 = oldReg - this.oldToNew.size(); i15 >= 0; --i15) {
                this.oldToNew.add(-1);
            }
        }
        this.oldToNew.set(oldReg, newReg);
        if (this.runningCountNewRegisters < newReg + category) {
            this.runningCountNewRegisters = newReg + category;
        }
    }
}

