/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dex.DexException;
import com.android.dx.io.OpcodeInfo;
import com.android.dx.io.instructions.DecodedInstruction;

public final class CodeReader {
    private Visitor fallbackVisitor = null;
    private Visitor stringVisitor = null;
    private Visitor typeVisitor = null;
    private Visitor fieldVisitor = null;
    private Visitor methodVisitor = null;
    private Visitor methodAndProtoVisitor = null;
    private Visitor callSiteVisitor = null;

    public void setAllVisitors(Visitor visitor2) {
        this.fallbackVisitor = visitor2;
        this.stringVisitor = visitor2;
        this.typeVisitor = visitor2;
        this.fieldVisitor = visitor2;
        this.methodVisitor = visitor2;
        this.methodAndProtoVisitor = visitor2;
        this.callSiteVisitor = visitor2;
    }

    public void setFallbackVisitor(Visitor visitor2) {
        this.fallbackVisitor = visitor2;
    }

    public void setStringVisitor(Visitor visitor2) {
        this.stringVisitor = visitor2;
    }

    public void setTypeVisitor(Visitor visitor2) {
        this.typeVisitor = visitor2;
    }

    public void setFieldVisitor(Visitor visitor2) {
        this.fieldVisitor = visitor2;
    }

    public void setMethodVisitor(Visitor visitor2) {
        this.methodVisitor = visitor2;
    }

    public void setMethodAndProtoVisitor(Visitor visitor2) {
        this.methodAndProtoVisitor = visitor2;
    }

    public void setCallSiteVisitor(Visitor visitor2) {
        this.callSiteVisitor = visitor2;
    }

    public void visitAll(DecodedInstruction[] decodedInstructions) throws DexException {
        int size = decodedInstructions.length;
        for (int i15 = 0; i15 < size; ++i15) {
            DecodedInstruction one = decodedInstructions[i15];
            if (one == null) continue;
            this.callVisit(decodedInstructions, one);
        }
    }

    public void visitAll(short[] encodedInstructions) throws DexException {
        DecodedInstruction[] decodedInstructions = DecodedInstruction.decodeAll(encodedInstructions);
        this.visitAll(decodedInstructions);
    }

    private void callVisit(DecodedInstruction[] all, DecodedInstruction one) {
        Visitor visitor2 = null;
        switch (OpcodeInfo.getIndexType(one.getOpcode())) {
            case STRING_REF: {
                visitor2 = this.stringVisitor;
                break;
            }
            case TYPE_REF: {
                visitor2 = this.typeVisitor;
                break;
            }
            case FIELD_REF: {
                visitor2 = this.fieldVisitor;
                break;
            }
            case METHOD_REF: {
                visitor2 = this.methodVisitor;
                break;
            }
            case METHOD_AND_PROTO_REF: {
                visitor2 = this.methodAndProtoVisitor;
                break;
            }
            case CALL_SITE_REF: {
                visitor2 = this.callSiteVisitor;
            }
        }
        if (visitor2 == null) {
            visitor2 = this.fallbackVisitor;
        }
        if (visitor2 != null) {
            visitor2.visit(all, one);
        }
    }

    public static interface Visitor {
        public void visit(DecodedInstruction[] var1, DecodedInstruction var2);
    }
}

