/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.VariableSizeInsn;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstLiteral32;
import com.android.dx.rop.cst.CstLiteral64;
import com.android.dx.rop.cst.CstType;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.ArrayList;

public final class ArrayData
extends VariableSizeInsn {
    private final CodeAddress user;
    private final ArrayList<Constant> values;
    private final Constant arrayType;
    private final int elemWidth;
    private final int initLength;

    public ArrayData(SourcePosition position, CodeAddress user, ArrayList<Constant> values2, Constant arrayType) {
        super(position, RegisterSpecList.EMPTY);
        if (user == null) {
            throw new NullPointerException("user == null");
        }
        if (values2 == null) {
            throw new NullPointerException("values == null");
        }
        int sz4 = values2.size();
        if (sz4 <= 0) {
            throw new IllegalArgumentException("Illegal number of init values");
        }
        this.arrayType = arrayType;
        if (arrayType == CstType.BYTE_ARRAY || arrayType == CstType.BOOLEAN_ARRAY) {
            this.elemWidth = 1;
        } else if (arrayType == CstType.SHORT_ARRAY || arrayType == CstType.CHAR_ARRAY) {
            this.elemWidth = 2;
        } else if (arrayType == CstType.INT_ARRAY || arrayType == CstType.FLOAT_ARRAY) {
            this.elemWidth = 4;
        } else if (arrayType == CstType.LONG_ARRAY || arrayType == CstType.DOUBLE_ARRAY) {
            this.elemWidth = 8;
        } else {
            throw new IllegalArgumentException("Unexpected constant type");
        }
        this.user = user;
        this.values = values2;
        this.initLength = values2.size();
    }

    @Override
    public int codeSize() {
        int sz4 = this.initLength;
        return 4 + (sz4 * this.elemWidth + 1) / 2;
    }

    @Override
    public void writeTo(AnnotatedOutput out) {
        int sz4 = this.values.size();
        out.writeShort(768);
        out.writeShort(this.elemWidth);
        out.writeInt(this.initLength);
        switch (this.elemWidth) {
            case 1: {
                for (int i15 = 0; i15 < sz4; ++i15) {
                    Constant cst = this.values.get(i15);
                    out.writeByte((byte)((CstLiteral32)cst).getIntBits());
                }
                break;
            }
            case 2: {
                for (int i16 = 0; i16 < sz4; ++i16) {
                    Constant cst = this.values.get(i16);
                    out.writeShort((short)((CstLiteral32)cst).getIntBits());
                }
                break;
            }
            case 4: {
                for (int i17 = 0; i17 < sz4; ++i17) {
                    Constant cst = this.values.get(i17);
                    out.writeInt(((CstLiteral32)cst).getIntBits());
                }
                break;
            }
            case 8: {
                for (int i18 = 0; i18 < sz4; ++i18) {
                    Constant cst = this.values.get(i18);
                    out.writeLong(((CstLiteral64)cst).getLongBits());
                }
                break;
            }
        }
        if (this.elemWidth == 1 && sz4 % 2 != 0) {
            out.writeByte(0);
        }
    }

    @Override
    public DalvInsn withRegisters(RegisterSpecList registers) {
        return new ArrayData(this.getPosition(), this.user, this.values, this.arrayType);
    }

    @Override
    protected String argString() {
        StringBuilder sb5 = new StringBuilder(100);
        int sz4 = this.values.size();
        for (int i15 = 0; i15 < sz4; ++i15) {
            sb5.append("\n    ");
            sb5.append(i15);
            sb5.append(": ");
            sb5.append(this.values.get(i15).toHuman());
        }
        return sb5.toString();
    }

    @Override
    protected String listingString0(boolean noteIndices) {
        int baseAddress = this.user.getAddress();
        StringBuilder sb5 = new StringBuilder(100);
        int sz4 = this.values.size();
        sb5.append("fill-array-data-payload // for fill-array-data @ ");
        sb5.append(Hex.u2(baseAddress));
        for (int i15 = 0; i15 < sz4; ++i15) {
            sb5.append("\n  ");
            sb5.append(i15);
            sb5.append(": ");
            sb5.append(this.values.get(i15).toHuman());
        }
        return sb5.toString();
    }
}

