/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dex.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathOpener {
    private final String pathname;
    private final Consumer consumer;
    private final boolean sort;
    private FileNameFilter filter;
    public static final FileNameFilter acceptAll = new FileNameFilter(){

        @Override
        public boolean accept(String path) {
            return true;
        }
    };

    public ClassPathOpener(String pathname, boolean sort, Consumer consumer) {
        this(pathname, sort, acceptAll, consumer);
    }

    public ClassPathOpener(String pathname, boolean sort, FileNameFilter filter, Consumer consumer) {
        this.pathname = pathname;
        this.sort = sort;
        this.consumer = consumer;
        this.filter = filter;
    }

    public boolean process() {
        File file2 = new File(this.pathname);
        return this.processOne(file2, true);
    }

    private boolean processOne(File file2, boolean topLevel) {
        try {
            if (file2.isDirectory()) {
                return this.processDirectory(file2, topLevel);
            }
            String path = file2.getPath();
            if (path.endsWith(".zip") || path.endsWith(".jar") || path.endsWith(".apk")) {
                return this.processArchive(file2);
            }
            if (this.filter.accept(path)) {
                byte[] bytes = FileUtils.readFile(file2);
                return this.consumer.processFileBytes(path, file2.lastModified(), bytes);
            }
            return false;
        }
        catch (Exception ex4) {
            this.consumer.onException(ex4);
            return false;
        }
    }

    private static int compareClassNames(String a15, String b15) {
        a15 = a15.replace('$', '0');
        b15 = b15.replace('$', '0');
        a15 = a15.replace("package-info", "");
        b15 = b15.replace("package-info", "");
        return a15.compareTo(b15);
    }

    private boolean processDirectory(File dir, boolean topLevel) {
        if (topLevel) {
            dir = new File(dir, ".");
        }
        File[] files = dir.listFiles();
        int len = files.length;
        boolean any = false;
        if (this.sort) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File a15, File b15) {
                    return ClassPathOpener.compareClassNames(a15.getName(), b15.getName());
                }
            });
        }
        for (int i15 = 0; i15 < len; ++i15) {
            any |= this.processOne(files[i15], false);
        }
        return any;
    }

    private boolean processArchive(File file2) throws IOException {
        ZipFile zip = new ZipFile(file2);
        ArrayList<? extends ZipEntry> entriesList = Collections.list(zip.entries());
        if (this.sort) {
            Collections.sort(entriesList, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry a15, ZipEntry b15) {
                    return ClassPathOpener.compareClassNames(a15.getName(), b15.getName());
                }
            });
        }
        this.consumer.onProcessArchiveStart(file2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(40000);
        byte[] buf = new byte[20000];
        boolean any = false;
        for (ZipEntry zipEntry : entriesList) {
            byte[] bytes;
            boolean isDirectory = zipEntry.isDirectory();
            String path = zipEntry.getName();
            if (!this.filter.accept(path)) continue;
            if (!isDirectory) {
                int read;
                InputStream in4 = zip.getInputStream(zipEntry);
                baos.reset();
                while ((read = in4.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
                in4.close();
                bytes = baos.toByteArray();
            } else {
                bytes = new byte[]{};
            }
            any |= this.consumer.processFileBytes(path, zipEntry.getTime(), bytes);
        }
        zip.close();
        return any;
    }

    public static interface FileNameFilter {
        public boolean accept(String var1);
    }

    public static interface Consumer {
        public boolean processFileBytes(String var1, long var2, byte[] var4);

        public void onException(Exception var1);

        public void onProcessArchiveStart(File var1);
    }
}

