/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.util.IntList;
import com.android.dx.util.MutabilityControl;

public final class SwitchList
extends MutabilityControl {
    private final IntList values;
    private final IntList targets;
    private int size;

    public SwitchList(int size) {
        super(true);
        this.values = new IntList(size);
        this.targets = new IntList(size + 1);
        this.size = size;
    }

    @Override
    public void setImmutable() {
        this.values.setImmutable();
        this.targets.setImmutable();
        super.setImmutable();
    }

    public int size() {
        return this.size;
    }

    public int getValue(int n15) {
        return this.values.get(n15);
    }

    public int getTarget(int n15) {
        return this.targets.get(n15);
    }

    public int getDefaultTarget() {
        return this.targets.get(this.size);
    }

    public IntList getTargets() {
        return this.targets;
    }

    public IntList getValues() {
        return this.values;
    }

    public void setDefaultTarget(int target) {
        this.throwIfImmutable();
        if (target < 0) {
            throw new IllegalArgumentException("target < 0");
        }
        if (this.targets.size() != this.size) {
            throw new RuntimeException("non-default elements not all set");
        }
        this.targets.add(target);
    }

    public void add(int value, int target) {
        this.throwIfImmutable();
        if (target < 0) {
            throw new IllegalArgumentException("target < 0");
        }
        this.values.add(value);
        this.targets.add(target);
    }

    public void removeSuperfluousDefaults() {
        this.throwIfImmutable();
        int sz4 = this.size;
        if (sz4 != this.targets.size() - 1) {
            throw new IllegalArgumentException("incomplete instance");
        }
        int defaultTarget = this.targets.get(sz4);
        int at4 = 0;
        for (int i15 = 0; i15 < sz4; ++i15) {
            int target = this.targets.get(i15);
            if (target == defaultTarget) continue;
            if (i15 != at4) {
                this.targets.set(at4, target);
                this.values.set(at4, this.values.get(i15));
            }
            ++at4;
        }
        if (at4 != sz4) {
            this.values.shrink(at4);
            this.targets.set(at4, defaultTarget);
            this.targets.shrink(at4 + 1);
            this.size = at4;
        }
    }
}

