/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.spi.ContextAware;

public class ConverterUtil {
    public static <E> void startConverters(Converter<E> head) {
        for (Converter<E> c15 = head; c15 != null; c15 = c15.getNext()) {
            if (c15 instanceof CompositeConverter) {
                CompositeConverter cc5 = (CompositeConverter)c15;
                Converter childConverter = cc5.childConverter;
                ConverterUtil.startConverters(childConverter);
                cc5.start();
                continue;
            }
            if (!(c15 instanceof DynamicConverter)) continue;
            DynamicConverter dc5 = (DynamicConverter)c15;
            dc5.start();
        }
    }

    public static <E> Converter<E> findTail(Converter<E> head) {
        Converter<E> next;
        Converter<E> p15 = head;
        while (p15 != null && (next = p15.getNext()) != null) {
            p15 = next;
        }
        return p15;
    }

    public static <E> void setContextForConverters(Context context, Converter<E> head) {
        for (Converter<E> c15 = head; c15 != null; c15 = c15.getNext()) {
            if (c15 instanceof ContextAware) {
                ((ContextAware)((Object)c15)).setContext(context);
            }
            if (!(c15 instanceof CompositeConverter)) continue;
            CompositeConverter cc5 = (CompositeConverter)c15;
            Converter childConverter = cc5.childConverter;
            ConverterUtil.setContextForConverters(context, childConverter);
        }
    }
}

