/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

public class JsonEscapeUtil {
    protected static final char[] HEXADECIMALS_TABLE = "0123456789ABCDEF".toCharArray();
    static final int ESCAPE_CODES_COUNT = 32;
    static final String[] ESCAPE_CODES = new String[32];

    private static String _computeEscapeCodeBelowASCII32(char c15) {
        if (c15 > ' ') {
            throw new IllegalArgumentException("input must be less than 32");
        }
        StringBuilder sb5 = new StringBuilder(6);
        sb5.append("\\u00");
        int highPart = c15 >> 4;
        sb5.append(HEXADECIMALS_TABLE[highPart]);
        int lowPart = c15 & 0xF;
        sb5.append(HEXADECIMALS_TABLE[lowPart]);
        return sb5.toString();
    }

    static String getObligatoryEscapeCode(char c15) {
        if (c15 < ' ') {
            return ESCAPE_CODES[c15];
        }
        if (c15 == '\"') {
            return "\\\"";
        }
        if (c15 == '/') {
            return "\\/";
        }
        if (c15 == '\\') {
            return "\\\\";
        }
        return null;
    }

    public static String jsonEscapeString(String input) {
        int length = input.length();
        int lenthWithLeeway = (int)((double)length * 1.1);
        StringBuilder sb5 = new StringBuilder(lenthWithLeeway);
        for (int i15 = 0; i15 < length; ++i15) {
            char c15 = input.charAt(i15);
            String escaped = JsonEscapeUtil.getObligatoryEscapeCode(c15);
            if (escaped == null) {
                sb5.append(c15);
                continue;
            }
            sb5.append(escaped);
        }
        return sb5.toString();
    }

    static {
        block7: for (char c15 = '\u0000'; c15 < ' '; c15 = (char)(c15 + '\u0001')) {
            switch (c15) {
                case '\b': {
                    JsonEscapeUtil.ESCAPE_CODES[c15] = "\\b";
                    continue block7;
                }
                case '\t': {
                    JsonEscapeUtil.ESCAPE_CODES[c15] = "\\t";
                    continue block7;
                }
                case '\n': {
                    JsonEscapeUtil.ESCAPE_CODES[c15] = "\\n";
                    continue block7;
                }
                case '\f': {
                    JsonEscapeUtil.ESCAPE_CODES[c15] = "\\f";
                    continue block7;
                }
                case '\r': {
                    JsonEscapeUtil.ESCAPE_CODES[c15] = "\\r";
                    continue block7;
                }
                default: {
                    JsonEscapeUtil.ESCAPE_CODES[c15] = JsonEscapeUtil._computeEscapeCodeBelowASCII32(c15);
                }
            }
        }
    }
}

