/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ConfiguratorRank;
import ch.qos.logback.classic.util.ClassicEnvUtil;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import java.util.Comparator;
import java.util.List;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";
    public static final String CONFIG_FILE_PROPERTY = "logback.configurationFile";
    String[] INTERNAL_CONFIGURATOR_CLASSNAME_LIST = new String[]{"ch.qos.logback.classic.util.DefaultJoranConfigurator", "ch.qos.logback.classic.BasicConfigurator"};
    final LoggerContext loggerContext;
    final ContextAware contextAware;
    Comparator<Configurator> rankComparator = new Comparator<Configurator>(){

        @Override
        public int compare(Configurator c15, Configurator c25) {
            ConfiguratorRank r15 = c15.getClass().getAnnotation(ConfiguratorRank.class);
            ConfiguratorRank r25 = c25.getClass().getAnnotation(ConfiguratorRank.class);
            int value1 = r15 == null ? 20 : r15.value();
            int value2 = r25 == null ? 20 : r25.value();
            int result = ContextInitializer.this.compareRankValue(value1, value2);
            return -result;
        }
    };

    public ContextInitializer(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
        this.contextAware = new ContextAwareImpl(loggerContext, this);
    }

    public void autoConfig() throws JoranException {
        this.autoConfig(Configurator.class.getClassLoader());
    }

    public void autoConfig(ClassLoader classLoader) throws JoranException {
        classLoader = Loader.systemClassloaderIfNull(classLoader);
        this.checkVersions();
        StatusListenerConfigHelper.installIfAsked(this.loggerContext);
        List<Configurator> configuratorList = ClassicEnvUtil.loadFromServiceLoader(Configurator.class, classLoader);
        configuratorList.sort(this.rankComparator);
        if (configuratorList.isEmpty()) {
            this.contextAware.addInfo("No custom configurators were discovered as a service.");
        } else {
            this.printConfiguratorOrder(configuratorList);
        }
        for (Configurator c15 : configuratorList) {
            if (this.invokeConfigure(c15) != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
        for (String configuratorClassName : this.INTERNAL_CONFIGURATOR_CLASSNAME_LIST) {
            this.contextAware.addInfo("Trying to configure with " + configuratorClassName);
            Configurator c16 = this.instantiateConfiguratorByClassName(configuratorClassName, classLoader);
            if (c16 == null || this.invokeConfigure(c16) != Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY) continue;
            return;
        }
    }

    private void checkVersions() {
        String versionOfLogbackCore;
        String versionOfLogbackClassic = ClassicEnvUtil.getVersionOfLogbackClassic();
        if (versionOfLogbackClassic == null) {
            versionOfLogbackClassic = "?";
        }
        if ((versionOfLogbackCore = EnvUtil.logbackVersion()) == null) {
            versionOfLogbackCore = "?";
        }
        this.loggerContext.getStatusManager().add(new InfoStatus("This is logback-classic version " + versionOfLogbackClassic, this.loggerContext));
        if (!versionOfLogbackCore.equals(versionOfLogbackClassic)) {
            this.loggerContext.getStatusManager().add(new InfoStatus("This is logback-core version " + versionOfLogbackCore, this.loggerContext));
            this.loggerContext.getStatusManager().add(new WarnStatus("Versions of logback-core and logback-classic are different!", this.loggerContext));
        }
    }

    private Configurator instantiateConfiguratorByClassName(String configuratorClassName, ClassLoader classLoader) {
        try {
            Class<?> classObj = classLoader.loadClass(configuratorClassName);
            return (Configurator)classObj.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e15) {
            this.contextAware.addInfo("Instantiation failure: " + e15.toString());
            return null;
        }
    }

    private Configurator.ExecutionStatus invokeConfigure(Configurator configurator) {
        try {
            long start = System.currentTimeMillis();
            this.contextAware.addInfo("Constructed configurator of type " + String.valueOf(configurator.getClass()));
            configurator.setContext(this.loggerContext);
            Configurator.ExecutionStatus status = configurator.configure(this.loggerContext);
            this.printDuration(start, configurator, status);
            return status;
        }
        catch (Exception e15) {
            throw new LogbackException(String.format("Failed to initialize or to run Configurator: %s", configurator != null ? configurator.getClass().getCanonicalName() : "null"), e15);
        }
    }

    private void printConfiguratorOrder(List<Configurator> configuratorList) {
        this.contextAware.addInfo("Here is a list of configurators discovered as a service, by rank: ");
        for (Configurator c15 : configuratorList) {
            this.contextAware.addInfo("  " + c15.getClass().getName());
        }
        this.contextAware.addInfo("They will be invoked in order until ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY is returned.");
    }

    private void printDuration(long start, Configurator configurator, Configurator.ExecutionStatus executionStatus) {
        long end = System.currentTimeMillis();
        long diff = end - start;
        this.contextAware.addInfo(configurator.getClass().getName() + ".configure() call lasted " + diff + " milliseconds. ExecutionStatus=" + String.valueOf((Object)executionStatus));
    }

    private Configurator.ExecutionStatus attemptConfigurationUsingJoranUsingReflexion(ClassLoader classLoader) {
        try {
            Class<?> djcClass = classLoader.loadClass("ch.qos.logback.classic.util.DefaultJoranConfigurator");
            Configurator c15 = (Configurator)djcClass.newInstance();
            c15.setContext(this.loggerContext);
            return c15.configure(this.loggerContext);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e15) {
            this.contextAware.addError("unexpected exception while instantiating DefaultJoranConfigurator", e15);
            return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
        }
    }

    private int compareRankValue(int value1, int value2) {
        if (value1 > value2) {
            return 1;
        }
        if (value1 == value2) {
            return 0;
        }
        return -1;
    }
}

