/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.BlockWithImpliedExitPath;
import antlr.CharFormatter;
import antlr.CodeGenerator;
import antlr.Grammar;
import antlr.JavaCharFormatter;
import antlr.Lookahead;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.Tool;
import antlr.ToolErrorHandler;

class DefaultToolErrorHandler
implements ToolErrorHandler {
    private final Tool antlrTool;
    CharFormatter javaCharFormatter = new JavaCharFormatter();

    DefaultToolErrorHandler(Tool tool) {
        this.antlrTool = tool;
    }

    private void dumpSets(String[] stringArray, int n15, Grammar grammar, boolean bl4, int n16, Lookahead[] lookaheadArray) {
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i15 = 1; i15 <= n16; ++i15) {
            stringBuffer.append("k==").append(i15).append(':');
            if (bl4) {
                String string = lookaheadArray[i15].fset.toStringWithRanges(",", this.javaCharFormatter);
                if (lookaheadArray[i15].containsEpsilon()) {
                    stringBuffer.append("<end-of-token>");
                    if (string.length() > 0) {
                        stringBuffer.append(',');
                    }
                }
                stringBuffer.append(string);
            } else {
                stringBuffer.append(lookaheadArray[i15].fset.toString(",", grammar.tokenManager.getVocabulary()));
            }
            stringArray[n15++] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
    }

    public void warnAltAmbiguity(Grammar grammar, AlternativeBlock alternativeBlock, boolean bl4, int n15, Lookahead[] lookaheadArray, int n16, int n17) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (alternativeBlock instanceof RuleBlock && ((RuleBlock)alternativeBlock).isLexerAutoGenRule()) {
            stringArray = alternativeBlock.getAlternativeAt(n16);
            Alternative alternative = alternativeBlock.getAlternativeAt(n17);
            RuleRefElement ruleRefElement = (RuleRefElement)stringArray.head;
            RuleRefElement ruleRefElement2 = (RuleRefElement)alternative.head;
            String string = CodeGenerator.reverseLexerRuleName(ruleRefElement.targetRule);
            String string2 = CodeGenerator.reverseLexerRuleName(ruleRefElement2.targetRule);
            stringBuffer.append("lexical nondeterminism between rules ");
            stringBuffer.append(string).append(" and ").append(string2).append(" upon");
        } else {
            if (bl4) {
                stringBuffer.append("lexical ");
            }
            stringBuffer.append("nondeterminism between alts ");
            stringBuffer.append(n16 + 1).append(" and ");
            stringBuffer.append(n17 + 1).append(" of block upon");
        }
        stringArray = new String[n15 + 1];
        stringArray[0] = stringBuffer.toString();
        this.dumpSets(stringArray, 1, grammar, bl4, n15, lookaheadArray);
        this.antlrTool.warning(stringArray, grammar.getFilename(), alternativeBlock.getLine(), alternativeBlock.getColumn());
    }

    public void warnAltExitAmbiguity(Grammar grammar, BlockWithImpliedExitPath blockWithImpliedExitPath, boolean bl4, int n15, Lookahead[] lookaheadArray, int n16) {
        String[] stringArray = new String[n15 + 2];
        stringArray[0] = (bl4 ? "lexical " : "") + "nondeterminism upon";
        this.dumpSets(stringArray, 1, grammar, bl4, n15, lookaheadArray);
        stringArray[n15 + 1] = "between alt " + (n16 + 1) + " and exit branch of block";
        this.antlrTool.warning(stringArray, grammar.getFilename(), blockWithImpliedExitPath.getLine(), blockWithImpliedExitPath.getColumn());
    }
}

