/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.time.Duration;
import java.util.Optional;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.steps.Context;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.timeout.Timeout;
import org.gradle.internal.execution.timeout.TimeoutHandler;
import org.gradle.internal.operations.CurrentBuildOperationRef;

public class TimeoutStep<C extends Context, R extends Result>
implements Step<C, R> {
    private final TimeoutHandler timeoutHandler;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final Step<? super C, ? extends R> delegate;

    public TimeoutStep(TimeoutHandler timeoutHandler, CurrentBuildOperationRef currentBuildOperationRef, Step<? super C, ? extends R> delegate) {
        this.timeoutHandler = timeoutHandler;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        Optional<Duration> timeoutProperty = work.getTimeout();
        if (timeoutProperty.isPresent()) {
            Duration timeout = timeoutProperty.get();
            if (timeout.isNegative()) {
                throw new InvalidUserDataException("Timeout of " + work.getDisplayName() + " must be positive, but was " + timeout.toString().substring(2));
            }
            return this.executeWithTimeout(work, context, timeout);
        }
        return this.executeWithoutTimeout(work, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R executeWithTimeout(UnitOfWork work, C context, Duration timeout) {
        Timeout taskTimeout = this.timeoutHandler.start(Thread.currentThread(), timeout, work, this.currentBuildOperationRef.get());
        try {
            R r = this.executeWithoutTimeout(work, context);
            return r;
        }
        finally {
            if (taskTimeout.stop()) {
                Thread.interrupted();
                throw new GradleException("Timeout has been exceeded");
            }
        }
    }

    private R executeWithoutTimeout(UnitOfWork work, C context) {
        return this.delegate.execute(work, context);
    }
}

