/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.DefaultBuildOperationIdFactory;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.Time;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.internal.consumer.ConnectionFactory;
import org.gradle.tooling.internal.consumer.DefaultCancellationTokenSource;
import org.gradle.tooling.internal.consumer.DefaultExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.ExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.GradleConnectorFactory;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.SynchronizedLogging;
import org.gradle.tooling.internal.consumer.loader.CachingToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.DefaultToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.SynchronizedToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ConnectorServices {
    private static GradleConnectorFactory sharedConnectorFactory = ConnectorServices.createConnectorFactory();

    public static CancellationTokenSource createCancellationTokenSource() {
        return new DefaultCancellationTokenSource();
    }

    public static GradleConnector createConnector() {
        return sharedConnectorFactory.createConnector();
    }

    public static void close() {
        sharedConnectorFactory.close();
    }

    @VisibleForTesting
    public static void reset() {
        ConnectorServices.close();
        sharedConnectorFactory = ConnectorServices.createConnectorFactory();
    }

    @VisibleForTesting
    public static GradleConnectorFactory createConnectorFactory() {
        return new DefaultGradleConnectorFactory();
    }

    @NullMarked
    private static class DefaultGradleConnectorFactory
    implements GradleConnectorFactory {
        private final CloseableServiceRegistry ownerRegistry = ConnectorServiceRegistry.access$100();

        private DefaultGradleConnectorFactory() {
        }

        @Override
        public GradleConnector createConnector() {
            return ((GradleConnectorFactory)this.ownerRegistry.get(GradleConnectorFactory.class)).createConnector();
        }

        @Override
        public void close() {
            this.ownerRegistry.close();
        }
    }

    @NullMarked
    private static class ConnectorServiceRegistry
    implements ServiceRegistrationProvider {
        private ConnectorServiceRegistry() {
        }

        private static CloseableServiceRegistry create() {
            return ServiceRegistryBuilder.builder().displayName("connector services").provider((ServiceRegistrationProvider)new ConnectorServiceRegistry()).build();
        }

        @Provides
        protected GradleConnectorFactory createConnectorFactory(final ConnectionFactory connectionFactory, final DistributionFactory distributionFactory) {
            return new GradleConnectorFactory(){

                @Override
                public GradleConnector createConnector() {
                    return new DefaultGradleConnector(connectionFactory, distributionFactory);
                }

                @Override
                public void close() {
                }
            };
        }

        @Provides
        protected ExecutorFactory createExecutorFactory() {
            return new DefaultExecutorFactory();
        }

        @Provides
        protected ExecutorServiceFactory createExecutorServiceFactory() {
            return new DefaultExecutorServiceFactory();
        }

        @Provides
        protected Clock createTimeProvider() {
            return Time.clock();
        }

        @Provides
        protected DistributionFactory createDistributionFactory(Clock clock) {
            return new DistributionFactory(clock);
        }

        @Provides
        protected ToolingImplementationLoader createToolingImplementationLoader() {
            return new SynchronizedToolingImplementationLoader(new CachingToolingImplementationLoader(new DefaultToolingImplementationLoader()));
        }

        @Provides
        protected BuildOperationIdFactory createBuildOperationIdFactory() {
            return new DefaultBuildOperationIdFactory();
        }

        @Provides
        protected LoggingProvider createLoggingProvider(Clock clock, BuildOperationIdFactory buildOperationIdFactory) {
            return new SynchronizedLogging(clock, buildOperationIdFactory);
        }

        @Provides
        protected ConnectionFactory createConnectionFactory(ToolingImplementationLoader toolingImplementationLoader, ExecutorFactory executorFactory, LoggingProvider loggingProvider) {
            return new ConnectionFactory(toolingImplementationLoader, executorFactory, loggingProvider);
        }

        static /* synthetic */ CloseableServiceRegistry access$100() {
            return ConnectorServiceRegistry.create();
        }
    }
}

