/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import java.util.ArrayList;
import java.util.List;
import tim.prune.data.Bearing;
import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.function.comparesegments.LineAndBearing;
import tim.prune.function.comparesegments.PointData;
import tim.prune.function.comparesegments.PointSequence;

public class SegmentData {
    private final PointSequence _points = new PointSequence();
    private final ArrayList<LineAndBearing> _lines = new ArrayList();
    private static final double MAX_ANGLE_CHANGE_DEGREES = 45.0;

    public SegmentData(Track track, int n) {
        SegmentData.fillPointData(track, this._points, n);
        this.fillLineData(this._points, this._lines);
    }

    private static void fillPointData(Track track, PointSequence pointSequence, int n) {
        ArrayList<DataPoint> arrayList = SegmentData.createPoints(track, n);
        DataPoint dataPoint = null;
        DataPoint dataPoint2 = null;
        double d = 0.0;
        for (DataPoint dataPoint3 : arrayList) {
            if (dataPoint2 != null) {
                double d2;
                double d3 = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2);
                d += d3;
                Object object = dataPoint == null ? Double.valueOf(Bearing.calculateDegrees(dataPoint2, dataPoint3)) : (dataPoint3 == null ? Double.valueOf(Bearing.calculateDegrees(dataPoint, dataPoint2)) : ((d2 = Bearing.calculateDegreeChange(dataPoint, dataPoint2, dataPoint3)) > 45.0 ? null : Double.valueOf(Bearing.calculateDegrees(dataPoint, dataPoint3))));
                if (object != null) {
                    d2 = SegmentData.getSpeedRadsPerSec(dataPoint, dataPoint2, dataPoint3);
                    pointSequence.addPoint(new PointData(dataPoint2, (Double)object, d3, d, d2));
                }
            }
            dataPoint = dataPoint2;
            dataPoint2 = dataPoint3;
        }
    }

    private static double getSpeedRadsPerSec(DataPoint dataPoint, DataPoint dataPoint2, DataPoint dataPoint3) {
        Timestamp timestamp = dataPoint == null ? dataPoint2.getTimestamp() : dataPoint.getTimestamp();
        Timestamp timestamp2 = dataPoint3 == null ? dataPoint2.getTimestamp() : dataPoint3.getTimestamp();
        long l = timestamp2.getMillisecondsSince(timestamp);
        double d = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2) + DataPoint.calculateRadiansBetween(dataPoint2, dataPoint3);
        return d * 1000.0 / (double)l;
    }

    private static ArrayList<DataPoint> createPoints(Track track, int n) {
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        int n2 = n;
        while (n2 < track.getNumPoints()) {
            DataPoint dataPoint = track.getPoint(n2);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                if (dataPoint.getSegmentStart() && n2 > n) break;
                arrayList.add(dataPoint);
            }
            ++n2;
        }
        arrayList.add(null);
        return arrayList;
    }

    private void fillLineData(PointSequence pointSequence, ArrayList<LineAndBearing> arrayList) {
        PointData pointData = null;
        for (PointData pointData2 : pointSequence.getPoints()) {
            if (pointData != null) {
                arrayList.add(new LineAndBearing(pointData, pointData2));
            }
            pointData = pointData2;
        }
    }

    boolean isBefore(SegmentData segmentData) {
        return this._points.getFirstTimestamp().isBefore(segmentData._points.getFirstTimestamp());
    }

    PointSequence getPoints() {
        return this._points;
    }

    List<LineAndBearing> getLines() {
        return this._lines;
    }
}

