---
stage: Runtime
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: プロジェクトの管理
description: 設定、設定、プロジェクトアクティビティー、プロジェクトの削除。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLabでのほとんどの作業は、[プロジェクト](_index.md)内で行われます。ファイルとコードはプロジェクトに保存され、ほとんどの機能はプロジェクトのスコーピング内にあります。

## プロジェクトの概要 {#project-overview}

{{< history >}}

- プロジェクトの作成日は、GitLab 16.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/19452)されました。

{{< /history >}}

プロジェクトを選択すると、**Project overview**（プロジェクトの概要）ページにプロジェクトの次の内容が表示されます:

- リポジトリ内のファイル
- プロジェクト情報（プロジェクトの説明）
- トピック
- バッジ
- プロジェクト内のお気に入り、フォーク、コミット、ブランチ、タグ、リリース、環境の数
- プロジェクトのストレージサイズ
- オプションのファイルと設定
- `README`またはインデックスファイル
  - Wikiページ
  - ライセンス
  - 変更履歴
  - コントリビュートのガイドライン
  - Kubernetesクラスター
  - CI/CD設定
  - インテグレーション
  - GitLab Pages
- 作成日

パブリックプロジェクト、および[プロジェクトのコードを表示する権限](../permissions.md#project-members-permissions)を持つ内部プロジェクトとプライベートプロジェクトのメンバーの場合、プロジェクトの概要ページには以下が表示されます:

- [`README`またはインデックスファイル](repository/files/_index.md#readme-and-index-files)
- プロジェクトのリポジトリ内のディレクトリのリスト

プロジェクトのコードを表示する権限を持たないユーザーの場合、概要ページには以下が表示されます:

- Wikiのホームページ。
- プロジェクト内のイシューのリスト。

`https://gitlab.example.com/projects/<id>`で、名前の代わりにIDを使用してプロジェクトにアクセスできます。たとえば、パーソナルネームスペース`alex`にID `123456`のプロジェクト`my-project`がある場合、`https://gitlab.example.com/alex/my-project`または`https://gitlab.example.com/projects/123456`でプロジェクトにアクセスできます。

{{< alert type="note" >}}

GitLab 17.5以降では、このエンドポイントに`https://gitlab.example.com/-/p/<id>`を使用することもできます。

{{< /alert >}}

## プロジェクトIDを見つける {#find-the-project-id}

[GitLab API](../../api/_index.md)を使用してプロジェクトを操作する場合は、プロジェクトIDが必要になる場合があります。

プロジェクトIDを見つけるには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. プロジェクトの概要ページの右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **Copy project ID**（プロジェクトIDをコピー）を選択します。

## プロジェクトを表示 {#view-projects}

**プロジェクト**リストを使用して、以下を表示します:

- インスタンス上のすべてのプロジェクト
- 作業または所有しているプロジェクト
- アーカイブされたプロジェクトや、削除保留中のプロジェクトなどの非アクティブなプロジェクト

### インスタンス上のすべてのプロジェクトを表示 {#view-all-projects-on-an-instance}

GitLabインスタンス上のプロジェクトを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **検索**を選択します。
1. オプション。タブを選択して、表示するプロジェクトをフィルタリングします。

認証されていない場合、リストにはパブリックプロジェクトのみが表示されます。

### 作業するプロジェクトを表示 {#view-projects-you-work-with}

{{< history >}}

- GitLab 17.9で`your_work_projects_vue`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/13066)されました。デフォルトでは無効になっています。
- GitLab 17.9で、`your_work_projects_vue`という[フラグ](../../administration/feature_flags/_index.md)とともに、タブのラベルが**Yours**から**メンバー**に[変更](https://gitlab.com/groups/gitlab-org/-/epics/13066)されました。デフォルトでは無効になっています。
- GitLab 17.10で、[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/465889)になりました。機能フラグ`your_work_projects_vue`は削除されました。

{{< /history >}}

インタラクトしたプロジェクトを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **すべてのプロジェクトを表示**を選択します。
1. オプション。タブを選択して、表示するプロジェクトを絞り込みます:
   - **コントリビュート済み**: 以下のプロジェクト:
     - イシュー、マージリクエスト、またはエピックを作成したプロジェクト
     - イシュー、マージリクエスト、またはエピックにコメントしたプロジェクト
     - イシュー、マージリクエスト、またはエピックを完了したプロジェクト
     - コミットをプッシュしたプロジェクト
     - マージリクエストを承認したプロジェクト
     - マージリクエストをマージしたプロジェクト
   - **Star付き**: [Star](#star-a-project)を付けたプロジェクト
   - **個人**: 個人のネームスペースで作成されたプロジェクト
   - **メンバー**: メンバーになっているプロジェクト
   - **無効**: アーカイブされたプロジェクトと削除保留中のプロジェクト

Star付きおよびパーソナルプロジェクトを個人のプロファイルから表示することもできます:

1. 左側のサイドバーで、自分のアバターを選択し、次にユーザー名を選択します。
1. 左側のサイドバーで、アバター、次にユーザー名を選択します。左側のサイドバーで、**Star付きのプロジェクト**または**パーソナルプロジェクト**を選択します。

### 非アクティブなプロジェクトを表示 {#view-inactive-projects}

{{< history >}}

- GitLab 17.9で、`your_work_projects_vue`[フラグ](../../administration/feature_flags/_index.md)とともに、タブのラベルが「削除の保留中」から「無効」に[変更](https://gitlab.com/groups/gitlab-org/-/epics/13066)されました。デフォルトでは無効になっています。
- GitLab 17.10で、[タブのラベルの一般提供が変更されました](https://gitlab.com/gitlab-org/gitlab/-/issues/465889)。機能フラグ`your_work_projects_vue`は削除されました。
- GitLab 18.0でGitLab PremiumからGitLab Freeに[移行](https://gitlab.com/groups/gitlab-org/-/epics/17208)しました。
- GitLab 18.0で、[パーソナルネームスペースのプロジェクトに対して有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/536244)。

{{< /history >}}

プロジェクトが非アクティブになるのは次の場合です:

- 削除が保留されている。
- アーカイブされている。

すべての非アクティブなプロジェクトを表示するには:

1. 次のいずれかを選択します:
   - **すべてのプロジェクトを表示**: プロジェクトを絞り込みます。
   - **検索**: アクセスできるすべてのプロジェクトをフィルタリングします。
1. **無効**タブを選択します。

リスト内の各プロジェクトには、以下が表示されます:

- プロジェクトがアーカイブされたか、削除対象としてマークされていることを示すバッジ。プロジェクトが削除対象としてマークされている場合、リストには以下も表示されます:
  - プロジェクトが削除対象としてマークされた時刻
  - プロジェクトが最終削除される予定の時刻
  - 最終的なプロジェクトの削除を停止する**復元**アクション

### 自分が所有するプロジェクトのみを表示する {#view-only-projects-you-own}

自分がオーナーであるプロジェクトのみを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. 次のいずれかを選択します:
   - **View all your projects**（すべてのプロジェクトを表示）: プロジェクトをフィルタリングします。
   - **検索**: アクセスできるすべてのプロジェクトをフィルタリングします。
1. プロジェクトリストの上にある**結果を検索またはフィルタリング**を選択します。
1. **ロール**ドロップダウンリストで、**オーナー**を選択します。

## プロジェクトアクティビティーを表示する {#view-project-activity}

プロジェクトのアクティビティーを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **管理** > **アクティビティー**を選択します。
1. オプション。コントリビュートの種類でアクティビティーをフィルタリングするには、次のタブを選択します:

   - **すべて**: プロジェクトメンバーによるすべてのコントリビュート
   - **プッシュイベント**: プロジェクト内のプッシュイベント
   - **マージイベント**: プロジェクトで承認されたマージリクエスト
   - **イシューイベント**: プロジェクトでオープンおよびクローズされたイシュー
   - **コメント**: プロジェクトメンバーが投稿したコメント
   - **デザイン**: プロジェクトで追加、更新、削除されたデザイン
   - **チーム**: プロジェクトに参加および離脱したメンバー

GitLabでは、パフォーマンス上の理由から、3年以上前のプロジェクトアクティビティーイベントをイベントテーブルから削除します。

## 言語でプロジェクトをフィルタリングする {#filter-projects-by-language}

{{< history >}}

- GitLab 15.9で`project_language_search`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/385465)されました。デフォルトでは有効になっています。
- GitLab 15.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110956)になりました。機能フラグ`project_language_search`は削除されました。

{{< /history >}}

使用されているプログラミング言語でプロジェクトをフィルタリングできます。以下を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. 次のいずれかを選択します:
   - **View all your projects**（すべてのプロジェクトを表示）: プロジェクトをフィルタリングします。
   - **検索**: アクセスできるすべてのプロジェクトをフィルタリングします。
1. プロジェクトリストの上にある**結果を検索またはフィルタリング**を選択します。
1. **言語**ドロップダウンリストで、プロジェクトのフィルタリングに使用する言語を選択します。

選択した言語を使用するプロジェクトのリストが表示されます。

## プロジェクトにStarを付ける {#star-a-project}

頻繁に使用するプロジェクトにスターを付けて、見つけやすくすることができます。

プロジェクトにStarを付けるには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. ページの右上隅にある**Star付き**を選択します。

## プロジェクトを離脱する {#leave-a-project}

{{< history >}}

- GitLab 16.7で、プロジェクトを離脱するためのボタンがアクションメニューに[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/431539)しました。

{{< /history >}}

プロジェクトを離脱すると、次のようになります:

- プロジェクトメンバーではなくなり、コントリビュートできなくなります。
- 割り当てられていたすべてのイシューとマージリクエストの割り当てが解除されます。

前提要件:

- プロジェクトが[グループネームスペース](../namespace/_index.md)のグループの一部である場合にのみ、この方法でプロジェクトを離脱できます。
- プロジェクトの[直接メンバー](members/_index.md#membership-types)である必要があります。

プロジェクトを離脱するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. プロジェクトの概要ページの右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **プロジェクトを離脱**を選択し、もう一度**プロジェクトを離脱**を選択します。

## プロジェクトを編集する {#edit-a-project}

プロジェクトの一般設定を使用して、プロジェクトの詳細を編集します。

前提要件:

- プロジェクトのメンテナーロール以上が必要です。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **プロジェクト名**テキストボックスに、プロジェクト名を入力します。[プロジェクト名の制限](../reserved_names.md)を参照してください。
1. オプション。**プロジェクトの説明**テキストボックスに、プロジェクトの説明を入力します。説明は2,000文字に制限されています。CI/CDカタログに公開されているコンポーネントには、プロジェクトの説明が必要です。
1. **変更を保存**を選択します。

### リポジトリの名前を変更する {#rename-a-repository}

プロジェクトのリポジトリ名は、そのURLを定義します。

前提要件:

- 管理者であるか、プロジェクトのメンテナーまたはオーナーのロールを持っている必要があります。

{{< alert type="note" >}}

リポジトリパスを変更すると、ユーザーが古いURLにプッシュまたはプルした場合に問題が発生する可能性があります。リダイレクト期間とその副作用の詳細については、[リポジトリの名前変更時のリダイレクト](repository/_index.md#repository-path-changes)を参照してください。

{{< /alert >}}

リポジトリの名前を変更するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **パスを変更**テキストボックスで、パスを編集します。
1. **パスを変更**を選択します。

### プロジェクトアバターを追加する {#add-a-project-avatar}

プロジェクトを視覚的に識別できるように、プロジェクトアバターを追加します。アバターを追加しない場合、GitLabはプロジェクト名の最初の文字をデフォルトのプロジェクトアバターとして表示します。

プロジェクトアバターを追加するには、次のいずれかの方法を使用します:

- リポジトリにロゴを追加する
- プロジェクトの設定でアバターをアップロードします。

#### リポジトリにロゴを追加する {#add-a-logo-to-your-repository}

プロジェクト設定にアバターをアップロードしていない場合、GitLabは`logo`という名前のファイルをリポジトリで検索し、デフォルトのプロジェクトアバターとして使用します。

前提要件:

- プロジェクトのメンテナー以上のロールを持っている必要があります。
- ファイルのサイズは200 KB以下である必要があります。理想的な画像サイズは192 x 192ピクセルです。
- ファイルの名前は`logo`で、拡張子は`.png`、`.jpg`、または`.gif`である必要があります。たとえば、`logo.gif`などです。

プロジェクトアバターとして使用するロゴファイルを追加するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. プロジェクトリポジトリのルートで、ロゴファイルをアップロードします。

#### プロジェクトの設定でアバターをアップロードする {#upload-an-avatar-in-project-settings}

前提要件:

- プロジェクトのメンテナー以上のロールを持っている必要があります。
- ファイルのサイズは200 KB以下である必要があります。理想的な画像サイズは192 x 192ピクセルです。
- 画像は、次のいずれかのファイル形式である必要があります:
  - `.bmp`
  - `.gif`
  - `.ico`
  - `.jpeg`
  - `.png`
  - `.tiff`

プロジェクトの設定でアバターをアップロードするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **プロジェクトアバター**セクションで、**ファイルを選択**を選択します。
1. アバターファイルを選択します。
1. **変更を保存**を選択します。

## プロジェクトを削除する {#delete-a-project}

{{< history >}}

- 16.0の[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/393622)および[GitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/119606)で、PremiumプランとUltimateプランにおけるデフォルトの動作が、遅延プロジェクト削除に[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/389557)されました。
- GitLab 16.0の[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/393622)および[GitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/119606)で、グループ設定としてプロジェクトを直ちに削除するオプションが削除されました。
- 18.0の[GitLab Free](https://gitlab.com/groups/gitlab-org/-/epics/17208)および[パーソナルプロジェクト](https://gitlab.com/gitlab-org/gitlab/-/issues/536244)で、デフォルトの動作が遅延プロジェクト削除に変更されました。
- プロジェクトを直ちに削除するオプションは、18.0でGitLab PremiumからGitLab Freeに[移行](https://gitlab.com/groups/gitlab-org/-/epics/17208)しました。
- GitLab 18.4で、削除予定のグループまたはプロジェクトの即時削除を禁止するサポートが、`disallow_immediate_deletion`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201957)されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

プロジェクトの削除をスケジュールできます。デフォルトでは、プロジェクトを初めて削除すると、削除保留状態になります。プロジェクトを直ちに削除するには、プロジェクトをもう一度削除します。

GitLab.comでは、プロジェクトが削除された後、そのデータは30日間保持されます。

前提要件: 

- プロジェクトのオーナーロールを持っている必要があります。
- [オーナー](../../administration/settings/visibility_and_access_controls.md#restrict-project-deletion-to-administrators)は、プロジェクトの削除を許可されている必要があります。

プロジェクトを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **プロジェクトを削除**セクションで、**プロジェクトを削除**を選択します。
1. 確認ダイアログで、プロジェクト名を入力し、**はい、プロジェクトを削除します**を選択します。
1. オプション。プロジェクトを直ちに削除するには、これらの手順を繰り返します。

[Railsコンソールを使用してプロジェクトを削除](troubleshooting.md#delete-a-project-using-console)することもできます。

プロジェクトの削除をスケジュールしたユーザーが、削除の実行前にプロジェクトへのアクセス権を失った場合（たとえば、プロジェクトから離れたり、ロールがダウングレードされたり、プロジェクトからBANされたりした場合）、削除ジョブはプロジェクトを復元します。ただし、削除ジョブの実行前にユーザーがアクセス権を回復した場合、ジョブはプロジェクトを完全に削除します。

### プロジェクトを復元する {#restore-a-project}

{{< history >}}

- GitLab 18.0でGitLab PremiumからGitLab Freeに[移行](https://gitlab.com/groups/gitlab-org/-/epics/17208)しました。
- GitLab 18.0で、[パーソナルネームスペースのプロジェクトに対して有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/536244)。

{{< /history >}}

前提要件: 

- プロジェクトのオーナーロールを持っている必要があります。

削除保留中のプロジェクトを復元するには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **プロジェクトを復元**セクションで、**プロジェクトを復元**を選択します。

## プロジェクトをアーカイブする {#archive-a-project}

{{< history >}}

- GitLab 17.5で、Pagesの削除が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/343109)されました。

{{< /history >}}

プロジェクトをアーカイブして読み取り専用にし、将来の参照のためにデータを保持します。

プロジェクトをアーカイブすると:

- プロジェクトが非アクティブになり、`Archived`バッジが表示されます。
- ほとんどの機能が読み取り専用になります（リポジトリ、イシュー、マージリクエスト、パッケージなど）。
- フォークの関係が削除され、フォークからのオープンマージリクエストが閉じられます
- デプロイされたPagesは、カスタムドメインとともに削除されます
- スケジュールされたCI/CDパイプラインの実行が停止されます
- プルミラーリングが停止します

前提要件: 

- 管理者であるか、プロジェクトのオーナーロールを持っている必要があります。

プロジェクトをアーカイブするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **プロジェクトのアーカイブ**セクションで、**アーカイブ**を選択します。

**あなたの作業**リストビューから直接プロジェクトをアーカイブするには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **すべてのプロジェクトを表示**を選択します。
1. **メンバー**タブで、アーカイブするプロジェクトを見つけて({{< icon name="ellipsis_v" >}})を選択します。
1. **アーカイブ**を選択します。

この操作は、他のリストされたページでも使用できます。

### プロジェクトのアーカイブを解除する {#unarchive-a-project}

プロジェクトをアーカイブ解除すると、次のようになります:

- 読み取り専用の制限が解除されます
- プロジェクトは非アクティブとしてマークされなくなります
- スケジュールされたCI/CDパイプラインが自動的に再開されます
- プルミラーリングが自動的に再開されます

グループのアーカイブの一部としてアーカイブされたプロジェクトは、個別にアーカイブ解除できません。すべてのプロジェクトとサブグループをアーカイブ解除するには、[親グループをアーカイブ解除する](../group/manage.md#unarchive-a-group)必要があります。

{{< alert type="note" >}}

デプロイされたPagesは自動的に復元されません。Pagesを復元するには、パイプラインを再実行する必要があります。

{{< /alert >}}

前提要件: 

- 管理者であるか、プロジェクトのオーナーロールを持っている必要があります。

プロジェクトのアーカイブを解除します:

1. アーカイブされたプロジェクトを検索します。
   1. 左側のサイドバーで、**検索または移動先**を選択します。
   1. **すべてのプロジェクトを表示**を選択します。
   1. **無効**タブで、プロジェクトを選択します。
1. 左側のサイドバーで、**設定** > **一般**を選択します。
1. **高度な設定**で、**全て展開**を選択します。
1. **プロジェクトのアーカイブ解除**セクションで、**アーカイブ解除**を選択します。

**あなたの作業**リストビューから直接プロジェクトをアーカイブ解除するには、次の手順を実行します:

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **すべてのプロジェクトを表示**を選択します。
1. **無効**タブで、アーカイブ解除するプロジェクトを見つけて({{< icon name="ellipsis_v" >}})を選択します。
1. **アーカイブ解除**を選択します。

この操作は、他のリストされたページでも使用できます。

## プロジェクトを転送する {#transfer-a-project}

{{< history >}}

- 同じトップレベルのネームスペース内でコンテナイメージを使用してプロジェクトを転送するためのサポートが、GitLab 17.7のGitLab.comで[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/499163)されました（`transfer_project_with_tags`という名前の[フラグ](../../administration/feature_flags/_index.md)付き）。デフォルトでは無効になっています。
- 同じトップレベルのネームスペース内でコンテナイメージを使用してプロジェクトを転送するためのサポートが、GitLab 17.7でGitLab.comで[有効](https://gitlab.com/gitlab-org/gitlab/-/issues/499163)になりました。機能フラグは削除されました。

{{< /history >}}

プロジェクトを転送して、別のグループに移動します。プロジェクトの転送には以下が含まれます:

- プロジェクトのコンポーネント:
  - イシュー
  - マージリクエスト
  - パイプライン
  - ダッシュボード
- プロジェクトメンバー:
  - 直接のメンバー
  - メンバーシップの招待

   {{< alert type="note" >}}

   プロジェクトの[継承されたメンバーシップ](members/_index.md#membership-types)を持つメンバーは、ターゲットグループのメンバーでもある場合を除き、アクセス権を失います。プロジェクトは、転送先のグループから新しいメンバー権限を継承します。

   {{< /alert >}}

プロジェクトの[パスも変更される](repository/_index.md#repository-path-changes)ため、必要に応じてプロジェクトコンポーネントへのURLを更新してください。

ターゲットネームスペースに一致するグループラベルがまだ存在しない場合は、新しいプロジェクトレベルのラベルがイシューとマージリクエストに作成されます。

プロジェクトにエピックに割り当てられたイシューが含まれており、そのエピックがターゲットグループで使用できない場合、GitLabはターゲットグループにエピックのコピーを作成します。同じエピックに割り当てられたイシューを含む複数のプロジェクトを転送すると、GitLabはプロジェクトごとにターゲットグループにそのエピックの個別のコピーを作成します。

{{< alert type="warning" >}}

転送プロセス中のエラーにより、プロジェクトのコンポーネントまたはエンドユーザーの依存のデータが失われる可能性があります。

{{< /alert >}}

前提要件: 

- 転送先の[グループ](../group/_index.md#create-a-group)のメンテナーロール以上が必要です。
- 転送するプロジェクトのオーナーである必要があります。
- グループは新しいプロジェクトの作成を許可する必要があります。
- コンテナレジストリが有効になっているプロジェクトの場合:
  - GitLab.comの場合: 同じトップレベルのネームスペース内でプロジェクトのみを転送できます。
  - GitLab Self-Managedの場合: プロジェクトに[コンテナイメージ](../packages/container_registry/_index.md#move-or-rename-container-registry-repositories)を含めることはできません。
- プロジェクトにセキュリティポリシーがあってはなりません。セキュリティポリシーがプロジェクトに割り当てられている場合、転送中に自動的に失効します。
- ルートネームスペースが変更された場合は、[命名規則](../packages/npm_registry/_index.md#naming-convention)に従うNPMパッケージをプロジェクトから削除する必要があります。プロジェクトを転送した後、次のいずれかの操作を実行できます:

  - 新しいルートネームスペースパスでパッケージスコープを更新し、プロジェクトに再度公開します。
  - ルートネームスペースパスを更新せずにパッケージをプロジェクトに再公開すると、パッケージが命名規則に従わなくなります。ルートネームスペースパスを更新せずにパッケージを再公開すると、[インスタンスエンドポイント](../packages/npm_registry/_index.md#install-from-an-instance)では使用できなくなります。

プロジェクトを転送するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **設定** > **一般**を選択します。
1. **高度な設定**を展開します。
1. **プロジェクトの転送**で、プロジェクトの転送先のネームスペースを選択します。
1. **プロジェクトの転送**を選択します。
1. プロジェクトの名前を入力し、**確認**を選択します。

プロジェクトの新しいページにリダイレクトされ、GitLabによってリダイレクトが適用されます。リポジトリのリダイレクトの詳細については、[リポジトリパスの変更](repository/_index.md#repository-path-changes)を参照してください。

{{< alert type="note" >}}管理者は、[管理者エリア](../../administration/admin_area.md#administering-projects)からプロジェクトを転送することもできます。

{{< /alert >}}

### GitLab.comプロジェクトを別のサブスクリプション層に転送する {#transfer-a-gitlabcom-project-to-a-different-subscription-tier}

GitLab.com PremiumまたはUltimateプランのライセンスが付与されたネームスペースからプロジェクトをFreeに転送する場合:

- [プロジェクトアクセストークン](settings/project_access_tokens.md)は失効します。
- [パイプラインのサブスクリプション](../../ci/pipelines/_index.md#trigger-a-pipeline-when-an-upstream-project-is-rebuilt-deprecated)と[テストケース](../../ci/test_cases/_index.md)が削除されます。

## [アクション]メニューを使用してプロジェクトを管理する {#manage-projects-with-the-actions-menu}

すべてのプロジェクトのリストを表示し、**アクション**メニューで管理できます。

前提要件: 

- アクションを実行するには、必要な[プロジェクト権限](../../user/permissions.md#projects)が必要です。

**アクション**メニューを使用してプロジェクトを管理するには:

1. 左側のサイドバーで、**検索または移動先**先 > **すべてのプロジェクトを表示**を選択します。
1. **プロジェクト**ページで、プロジェクトを見つけて**アクション**メニュー（{{< icon name="ellipsis_v" >}}）を選択します。
1. アクションを選択してください。

以下の操作は、プロジェクトの状態によって利用可能です:

| プロジェクトの状態    | 利用可能なアクション |
|----------|-------------------------|
| アクティブ   | **編集**、**アーカイブ**、**転送**、**プロジェクトを離脱**、**削除** |
| アーカイブ済み | **アーカイブ解除**、**プロジェクトを離脱**、**削除** |
| 削除保留中 | **復元**、**プロジェクトを離脱** |

## プロジェクトにコンプライアンスフレームワークを追加する {#add-a-compliance-framework-to-a-project}

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

[コンプライアンスフレームワーク](../compliance/compliance_frameworks/_index.md)があるグループのプロジェクトにコンプライアンスフレームワークを追加できます。

## LDAPグループを介してプロジェクトへのアクセスを管理する {#manage-project-access-through-ldap-groups}

[LDAPを使用してグループメンバーシップを管理](../group/access_and_permissions.md#manage-group-memberships-with-ldap)できます。

LDAPグループを使用してプロジェクトへのアクセスを管理することはできませんが、次の回避策を使用できます。

前提要件: 

- [LDAPをGitLabと統合](../../administration/auth/ldap/_index.md)する必要があります。
- 管理者である必要があります。

1. プロジェクトのメンバーシップを追跡するための[グループを作成](../group/_index.md#create-a-group)します。
1. そのグループの[LDAP同期を設定](../../administration/auth/ldap/ldap_synchronization.md)します。
1. LDAPグループを使用してプロジェクトへのアクセスを管理するには、[LDAP同期されたグループをメンバーとして追加](../group/manage.md)します。

## プロジェクトエイリアス {#project-aliases}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

通常、GitLabリポジトリには、ネームスペースとプロジェクト名を使用してアクセスします。ただし、頻繁にアクセスされるリポジトリをGitLabに移行する場合は、プロジェクトエイリアスを使用して、元の名前でそれらのリポジトリにアクセスできます。プロジェクトエイリアスを介してリポジトリにアクセスすると、そのようなリポジトリの移行に関連するリスクが軽減されます。

この機能は、SSH経由のGitでのみ使用できます。また、プロジェクトエイリアスを作成できるのはGitLab管理者のみであり、APIを介してのみ作成できます。詳細については、[プロジェクトエイリアスAPIドキュメント](../../api/project_aliases.md)を参照してください。

管理者がプロジェクトのエイリアスを作成すると、そのエイリアスを使用してリポジトリのクローンを作成できます。たとえば、管理者がプロジェクト`https://gitlab.com/gitlab-org/gitlab`のエイリアス`gitlab`を作成した場合、`git clone git@gitlab.com:gitlab-org/gitlab.git`の代わりに`git clone git@gitlab.com:gitlab.git`を使用してプロジェクトのクローンを作成できます。

## 関連トピック {#related-topics}

- [プロジェクトをインポートする](import/_index.md)
- [外部リポジトリをGitLab CI/CDに接続する](../../ci/ci_cd_for_external_repos/_index.md)
- [プロジェクトをフォークする](repository/forking_workflow.md#create-a-fork)
- [プロジェクトの表示レベル](../public_access.md#change-project-visibility)と[権限](settings/_index.md#configure-project-features-and-permissions)を調整する
- [プロジェクト名とグループ名のルール](../reserved_names.md#rules-for-usernames-project-and-group-names-and-slugs)
