# frozen_string_literal: true

class FinalizeBackfillPCiPipelineVariablesProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.9'
  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_ci

  MIGRATION = 'BackfillPCiPipelineVariablesProjectId'
  TABLE_NAME = 'p_ci_pipeline_variables'

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: MIGRATION,
      table_name: TABLE_NAME,
      column_name: :id,
      job_arguments: [
        :project_id,
        :p_ci_pipelines,
        :project_id,
        :pipeline_id,
        :partition_id
      ],
      finalize: true
    )
  end

  def down
    # no-op
  end
end
