# ALCO, chapter 2
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("alco02.tst");

# doc/ALCO.xml:140-157
gap> O := OctonionAlgebra(Rationals);
<algebra-with-one of dimension 8 over Rationals>
gap> LeftActingDomain(O);
Rationals
gap> IsAssociative(O);
false
gap> e := BasisVectors(Basis(O));
[ e1, e2, e3, e4, e5, e6, e7, e8 ]
gap> One(O);
e8
gap> e[1]*e[2];
e4
gap> e[2]*e[1];
(-1)*e4
gap> Derivations(Basis(O));
<Lie algebra of dimension 14 over Rationals>
gap> SemiSimpleType(last);
"G2"

# doc/ALCO.xml:171-184
gap> a := BasisVectors(Basis(OctavianIntegers));;
gap> for x in a do Display(x); od;
(-1/2)*e1+(1/2)*e5+(1/2)*e6+(1/2)*e7
(-1/2)*e1+(-1/2)*e2+(-1/2)*e4+(-1/2)*e7
(1/2)*e2+(1/2)*e3+(-1/2)*e5+(-1/2)*e7
(1/2)*e1+(-1/2)*e3+(1/2)*e4+(1/2)*e5
(-1/2)*e2+(1/2)*e3+(-1/2)*e5+(1/2)*e7
(1/2)*e2+(-1/2)*e4+(1/2)*e5+(-1/2)*e6
(-1/2)*e1+(-1/2)*e3+(1/2)*e4+(-1/2)*e5
(1/2)*e1+(-1/2)*e4+(1/2)*e6+(-1/2)*e8
gap> ForAll(a, IsOctavianInt);
true
gap> ForAll(a/2, IsOctavianInt);
false

# doc/ALCO.xml:195-200
gap> BasisVectors(OctonionE8Basis) = BasisVectors(Basis(OctavianIntegers));
true
gap> g := List(OctonionE8Basis, x -> List(OctonionE8Basis, y -> 
> Norm(x+y) - Norm(x) - Norm(y)));;
gap> IsGossetLatticeGramMatrix(g);
true

# doc/ALCO.xml:218-223
gap> Oct := OctonionAlgebra(Rationals);;
gap> List(Basis(Oct), Norm);
[ 1, 1, 1, 1, 1, 1, 1, 1 ]
gap> x := Random(Oct);; y := Random(Oct);;
gap> Norm(x*y) = Norm(x)*Norm(y);
true

# doc/ALCO.xml:236-241
gap> e := BasisVectors(Basis(OctonionAlgebra(Rationals)));
[ e1, e2, e3, e4, e5, e6, e7, e8 ]
gap> List(e, Trace);
[ 0, 0, 0, 0, 0, 0, 0, 2 ]
gap> List(e, RealPart);
[ 0*e1, 0*e1, 0*e1, 0*e1, 0*e1, 0*e1, 0*e1, e8 ]

# doc/ALCO.xml:250-253
gap> e := BasisVectors(Basis(OctonionAlgebra(Rationals)));
[ e1, e2, e3, e4, e5, e6, e7, e8 ]
gap> List(e, ComplexConjugate);
[ (-1)*e1, (-1)*e2, (-1)*e3, (-1)*e4, (-1)*e5, (-1)*e6, (-1)*e7, e8 ]

# doc/ALCO.xml:261-264
gap> e := BasisVectors(Basis(OctonionAlgebra(Rationals)));
[ e1, e2, e3, e4, e5, e6, e7, e8 ]
gap> List(e, RealPart);
[ 0*e1, 0*e1, 0*e1, 0*e1, 0*e1, 0*e1, 0*e1, e8 ]

# doc/ALCO.xml:284-293
gap> O := UnderlyingLeftModule(OctonionE8Basis);
<algebra-with-one of dimension 8 over Rationals>
gap> BasisVectors(CanonicalBasis(O));
[ e1, e2, e3, e4, e5, e6, e7, e8 ]
gap> x := 2*OctonionE8Basis{[1,2]};
[ (-1)*e1+e5+e6+e7, (-1)*e1+(-1)*e2+(-1)*e4+(-1)*e7 ]
gap> y := OctonionToRealVector(CanonicalBasis(O), x);
[ -1, 0, 0, 0, 1, 1, 1, 0, -1, -1, 0, -1, 0, 0, -1, 0 ]
gap> RealToOctonionVector(CanonicalBasis(O), y);
[ (-1)*e1+e5+e6+e7, (-1)*e1+(-1)*e2+(-1)*e4+(-1)*e7 ]

# doc/ALCO.xml:304-312
gap> Oct := OctonionAlgebra(Rationals);;
gap> x := Basis(Oct){[8,1,2]};
[ e8, e1, e2 ]
gap> y := VectorToIdempotentMatrix(x);; Display(y);
[ [   (1/3)*e8,   (1/3)*e1,   (1/3)*e2 ],
  [  (-1/3)*e1,   (1/3)*e8,  (-1/3)*e4 ],
  [  (-1/3)*e2,   (1/3)*e4,   (1/3)*e8 ] ]
gap> IsIdempotent(y);
true

# doc/ALCO.xml:324-325
gap> WeylReflection([1,0,1],[0,1,1]);
[ -1, 1, 0 ]

# doc/ALCO.xml:335-354
gap> H := QuaternionAlgebra(Rationals);
<algebra-with-one of dimension 4 over Rationals>
gap> IsQuaternion(Random(H));
true
gap> IsAssociative(H);
true
gap> IsCommutative(H);
false
gap> One(H);
e
gap> b := BasisVectors(CanonicalBasis(H));
[ e, i, j, k ]
gap> List(b, ComplexConjugate);
[ e, (-1)*i, (-1)*j, (-1)*k ]
gap> List(b, Inverse);
[ e, (-1)*i, (-1)*j, (-1)*k ] 
gap> List(b, RealPart);
[ e, 0*e, 0*e, 0*e ]
gap> List(b, ImaginaryPart);
[ 0*e, e, k, (-1)*j ]

# doc/ALCO.xml:363-370
gap> H := QuaternionAlgebra(Rationals);;
gap> b := BasisVectors(CanonicalBasis(H));
[ e, i, j, k ]
gap> List(b, Norm);
[ 1, 1, 1, 1 ]
gap> x := Random(H);; y := Random(H);;
gap> Norm(x*y) = Norm(x)*Norm(y);
true

# doc/ALCO.xml:379-383
gap> H := QuaternionAlgebra(Rationals);;
gap> b := BasisVectors(CanonicalBasis(H));
[ e, i, j, k ]
gap> List(b, Trace);
[ 2, 0, 0, 0 ]

# doc/ALCO.xml:397-406
gap> f := BasisVectors(Basis(HurwitzIntegers));;
gap> for x in f do Display(x); od;
(-1/2)*e+(-1/2)*i+(-1/2)*j+(1/2)*k
(-1/2)*e+(-1/2)*i+(1/2)*j+(-1/2)*k
(-1/2)*e+(1/2)*i+(-1/2)*j+(-1/2)*k
e
gap> ForAll(f, IsHurwitzInt);
true
gap> ForAll(f/2, IsHurwitzInt);
false

# doc/ALCO.xml:416-421
gap> B := QuaternionD4Basis;;
gap> for x in BasisVectors(B) do Display(x); od;
(-1/2)*e+(-1/2)*i+(-1/2)*j+(1/2)*k
(-1/2)*e+(-1/2)*i+(1/2)*j+(-1/2)*k
(-1/2)*e+(1/2)*i+(-1/2)*j+(-1/2)*k
e

# doc/ALCO.xml:452-469
gap> f := BasisVectors(Basis(IcosianRing));;
gap> for x in f do Display(x); od;
(-1)*i
(-1/2*E(5)^2-1/2*E(5)^3)*i+(1/2)*j+(-1/2*E(5)-1/2*E(5)^4)*k
(-1)*j
(-1/2*E(5)-1/2*E(5)^4)*e+(1/2)*j+(-1/2*E(5)^2-1/2*E(5)^3)*k
gap> ForAll(f, IsIcosian);
true
gap> ForAll(f/2, IsIcosian);
false
gap> ForAll(f*EB(5), IsIcosian);
true
gap> ForAll(f*Sqrt(5), IsIcosian);
true
gap> ForAll(f*(1-Sqrt(5))/2, IsIcosian);
true
gap> ForAll(f*(1+Sqrt(5))/2, IsIcosian);
true

# doc/ALCO.xml:479-484
gap> f := BasisVectors(IcosianH4Generators);;
gap> for x in f do Display(x); od;
(-1)*i
(-1/2*E(5)^2-1/2*E(5)^3)*i+(1/2)*j+(-1/2*E(5)-1/2*E(5)^4)*k
(-1)*j
(-1/2*E(5)-1/2*E(5)^4)*e+(1/2)*j+(-1/2*E(5)^2-1/2*E(5)^3)*k

# doc/ALCO.xml:494-500
gap> sigma := (1-Sqrt(5))/2;; tau := (1+Sqrt(5))/2;;
gap> x := 5 + 3*sigma;; GoldenModSigma(x);
5
gap> GoldenModSigma(sigma);
0
gap> GoldenModSigma(tau);
1

# doc/ALCO.xml:521-526
gap> f := BasisVectors(Basis(EisensteinIntegers));
[ 1, E(3) ]
gap> IsEisenInt(E(4));
false
gap> IsEisenInt(1+E(3)^2);
true

# doc/ALCO.xml:538-543
gap> f := BasisVectors(Basis(KleinianIntegers));
[ 1, E(7)+E(7)^2+E(7)^4 ]
gap> IsKleinInt(E(4));
false
gap> IsKleinInt(1+E(7)+E(7)^2+E(7)^4);
true

#
gap> STOP_TEST("alco02.tst", 1);
