/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.Color;
import java.awt.FontMetrics;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.freeplane.core.ui.components.IconListComponent;
import org.freeplane.core.ui.components.IconRow;
import org.freeplane.core.ui.components.MultipleImageIcon;
import org.freeplane.core.ui.components.ObjectIcon;
import org.freeplane.core.ui.components.TextIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class ASelectableCondition
implements ICondition {
    public static final float STRING_MIN_MATCH_PROB = 0.7f;
    private transient String description;
    private String userName;
    private static Method EQUALS;
    private static Method HASH;

    protected static Color operatorBackgroundColor() {
        Color optionBackgroundColor = UITools.isLightLookAndFeelInstalled() ? Color.BLACK.brighter() : Color.WHITE.darker();
        return optionBackgroundColor;
    }

    public int hashCode() {
        if (HASH == null) {
            return super.hashCode();
        }
        try {
            return (Integer)HASH.invoke(null, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.hashCode();
        }
    }

    public boolean equals(final Object obj) {
        if (EQUALS == null) {
            return super.equals(obj);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                    return (Boolean)EQUALS.invoke(null, ASelectableCondition.this, obj);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.equals(obj);
        }
    }

    protected abstract String createDescription();

    protected List<Icon> createRenderedIcons(String attribute, ConditionFactory.ConditionOperator simpleCondition, String value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics, FontMetrics fontMetrics) {
        return this.createRenderedIcons(attribute, simpleCondition, new TextIcon(value, fontMetrics), matchCase, matchApproximately, ignoreDiacritics, fontMetrics);
    }

    protected List<Icon> createRenderedIcons(String condition, FontMetrics fontMetrics) {
        return this.createRenderedIcons(condition, ConditionFactory.ConditionOperator.EMPTY, "", false, false, false, fontMetrics);
    }

    protected List<Icon> createRenderedIcons(String attribute, ConditionFactory.ConditionOperator conditionOperator, Icon valueIcon, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics, FontMetrics fontMetrics) {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        if (!attribute.isEmpty()) {
            icons.add(this.textIcon(attribute, fontMetrics));
        }
        String operator = conditionOperator.getOperator();
        Color optionBackgroundColor = ASelectableCondition.operatorBackgroundColor();
        boolean isOperatorBlank = operator.isEmpty() || operator.equals(" ");
        TextIcon operatorIcon = this.textIcon(operator, fontMetrics, icon -> {
            if (!isOperatorBlank) {
                icon.setIconBackgroundColor(optionBackgroundColor);
            }
        });
        TextIcon openingValueDelimiterIcon = this.textIcon(conditionOperator.getOpeningValueDelimiter(), fontMetrics);
        TextIcon closingValueDelimiterIcon = this.textIcon(conditionOperator.getClosingValueDelimiter(), fontMetrics);
        TextIcon gapIcon = this.textIcon(" ", fontMetrics);
        if (!operator.isEmpty()) {
            icons.add(gapIcon);
            if (!isOperatorBlank) {
                icons.add(operatorIcon);
                icons.add(gapIcon);
            }
        }
        icons.add(openingValueDelimiterIcon);
        icons.add(valueIcon);
        icons.add(closingValueDelimiterIcon);
        if (matchCase) {
            icons.add(gapIcon);
            icons.add(this.textIcon(ConditionFactory.ConditionOption.FILTER_MATCH_CASE.getDisplayedOption(), fontMetrics, icon -> icon.setIconBackgroundColor(optionBackgroundColor)));
        }
        if (ignoreDiacritics) {
            icons.add(gapIcon);
            icons.add(this.textIcon(ConditionFactory.ConditionOption.FILTER_IGNORE_DIACRITICS.getDisplayedOption(), fontMetrics, icon -> icon.setIconBackgroundColor(optionBackgroundColor)));
        }
        if (matchApproximately) {
            icons.add(gapIcon);
            icons.add(this.textIcon(ConditionFactory.ConditionOption.FILTER_MATCH_APPROX.getDisplayedOption(), fontMetrics, icon -> icon.setIconBackgroundColor(optionBackgroundColor)));
        }
        return icons;
    }

    protected TextIcon textIcon(String text, FontMetrics fontMetrics) {
        return this.textIcon(text, fontMetrics, x -> {});
    }

    protected TextIcon textIcon(String text, FontMetrics fontMetrics, Consumer<TextIcon> config) {
        TextIcon icon = new TextIcon(text, fontMetrics);
        config.accept(icon);
        return icon;
    }

    public final IconListComponent getListCellRendererComponent(FontMetrics fontMetrics) {
        IconListComponent renderer = this.createGraphicComponent(fontMetrics);
        renderer.setToolTipText(this.toString());
        return renderer;
    }

    public MultipleImageIcon createIcon(FontMetrics fontMetrics) {
        MultipleImageIcon multipleImageIcon = new MultipleImageIcon();
        List<Icon> icons = this.createSmallRendererIcons(fontMetrics);
        icons.forEach(multipleImageIcon::addIcon);
        return multipleImageIcon;
    }

    protected IconListComponent createGraphicComponent(FontMetrics fontMetrics) {
        List<Icon> icons = this.createRenderedIcons(fontMetrics);
        if (this.userName != null) {
            ArrayList<Icon> iconsWithName = new ArrayList<Icon>(icons.size() + 1);
            iconsWithName.add(new TextIcon(this.userName + " : ", fontMetrics));
            iconsWithName.addAll(icons);
            return this.createIconListComponent(iconsWithName);
        }
        return this.createIconListComponent(icons);
    }

    protected IconListComponent createIconListComponent(List<Icon> icons) {
        IconRow icon = new IconRow(icons);
        ObjectIcon<ASelectableCondition> o = new ObjectIcon<ASelectableCondition>(this, icon);
        List<ObjectIcon<ASelectableCondition>> singletonList = Collections.singletonList(o);
        return new IconListComponent(singletonList, this.toString());
    }

    protected abstract List<Icon> createRenderedIcons(FontMetrics var1);

    protected List<Icon> createRenderedIconsFromDescription(FontMetrics fontMetrics) {
        return Collections.singletonList(new TextIcon(this.toString(), fontMetrics));
    }

    protected String createDescription(String attribute, String simpleCondition, String value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        String description = this.createSimpleDescription(attribute, simpleCondition, value) + (matchCase && value != null ? ", " + TextUtils.getText(ConditionFactory.FILTER_MATCH_CASE) : "") + (matchApproximately && value != null ? ", " + TextUtils.getText(ConditionFactory.FILTER_MATCH_APPROX) : "" + (ignoreDiacritics && value != null ? ", " + TextUtils.getText(ConditionFactory.FILTER_IGNORE_DIACRITICS) : ""));
        return description;
    }

    protected String createDescription(String attribute, String simpleCondition, String value) {
        return this.createSimpleDescription(attribute, simpleCondition, value);
    }

    private String createSimpleDescription(String attribute, String simpleCondition, String value) {
        String description = attribute + " " + simpleCondition + (value != null ? " \"" + value + "\"" : "");
        return description;
    }

    public final String toString() {
        if (this.description == null) {
            this.description = this.createDescription();
        }
        return this.description;
    }

    public void toXml(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(this.getName());
        if (this.userName != null) {
            child.setAttribute("user_name", this.userName);
        }
        this.fillXML(child);
        element.addChild(child);
    }

    protected void fillXML(XMLElement element) {
    }

    protected abstract String getName();

    public void setUserName(String userName) {
        if (userName == this.userName || userName != null && userName.equals(this.userName)) {
            return;
        }
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    protected List<Icon> createSmallRendererIcons(FontMetrics fontMetrics) {
        if (this.userName == null) {
            return this.createRenderedIcons(fontMetrics);
        }
        return Collections.singletonList(new TextIcon('\"' + this.userName + '\"', fontMetrics));
    }

    protected String createSmallDescription() {
        if (this.userName == null) {
            return this.createDescription();
        }
        return '\"' + this.userName + '\"';
    }

    public boolean canBePersisted() {
        return true;
    }

    public ASelectableCondition removeCondition(ASelectableCondition removedCondition) {
        return removedCondition == this ? null : this;
    }

    static {
        try {
            ClassLoader classLoader = ASelectableCondition.class.getClassLoader();
            EQUALS = classLoader.loadClass("org.apache.commons.lang.builder.EqualsBuilder").getMethod("reflectionEquals", Object.class, Object.class);
            HASH = classLoader.loadClass("org.apache.commons.lang.builder.HashCodeBuilder").getMethod("reflectionHashCode", Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

