/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.transport.kex;

import com.hierynomus.sshj.transport.kex.DHG;
import java.math.BigInteger;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.digest.SHA1;
import net.schmizz.sshj.transport.digest.SHA256;
import net.schmizz.sshj.transport.digest.SHA512;
import net.schmizz.sshj.transport.kex.DHGroupData;
import net.schmizz.sshj.transport.kex.KeyExchange;

public class DHGroups {
    public static Factory Group1SHA1() {
        return new Factory("diffie-hellman-group1-sha1", DHGroupData.P1, DHGroupData.G, new SHA1.Factory());
    }

    public static Factory Group14SHA1() {
        return new Factory("diffie-hellman-group14-sha1", DHGroupData.P14, DHGroupData.G, new SHA1.Factory());
    }

    public static Factory Group14SHA256() {
        return new Factory("diffie-hellman-group14-sha256", DHGroupData.P14, DHGroupData.G, new SHA256.Factory());
    }

    public static Factory Group15SHA512() {
        return new Factory("diffie-hellman-group15-sha512", DHGroupData.P15, DHGroupData.G, new SHA512.Factory());
    }

    public static Factory Group16SHA512() {
        return new Factory("diffie-hellman-group16-sha512", DHGroupData.P16, DHGroupData.G, new SHA512.Factory());
    }

    public static Factory Group17SHA512() {
        return new Factory("diffie-hellman-group17-sha512", DHGroupData.P17, DHGroupData.G, new SHA512.Factory());
    }

    public static Factory Group18SHA512() {
        return new Factory("diffie-hellman-group18-sha512", DHGroupData.P18, DHGroupData.G, new SHA512.Factory());
    }

    public static class Factory
    implements Factory.Named<KeyExchange> {
        private final String name;
        private final BigInteger group;
        private final BigInteger generator;
        private final Factory.Named<Digest> digestFactory;

        public Factory(String name, BigInteger group, BigInteger generator, Factory.Named<Digest> digestFactory) {
            this.name = name;
            this.group = group;
            this.generator = generator;
            this.digestFactory = digestFactory;
        }

        @Override
        public KeyExchange create() {
            return new DHG(this.group, this.generator, (Digest)this.digestFactory.create());
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

