/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.util.LinkedList;
import java.util.List;

public abstract class ArgumentTokenizer {
    private static final int NO_TOKEN_STATE = 0;
    private static final int NORMAL_TOKEN_STATE = 1;
    private static final int SINGLE_QUOTE_STATE = 2;
    private static final int DOUBLE_QUOTE_STATE = 3;

    public static List<String> tokenize(String arguments) {
        return ArgumentTokenizer.tokenize(arguments, false);
    }

    public static List<String> tokenize(String arguments, boolean stringify) {
        int i;
        LinkedList<String> argList = new LinkedList<String>();
        StringBuilder currArg = new StringBuilder();
        boolean escaped = false;
        int state = 0;
        int len = arguments.length();
        block10: for (i = 0; i < len; ++i) {
            char c = arguments.charAt(i);
            if (escaped) {
                escaped = false;
                if (c != 'n' && c != 't' && c != '\\') {
                    currArg.append('\\');
                }
                currArg.append(c);
                continue;
            }
            switch (state) {
                case 2: {
                    if (c == '\'') {
                        state = 1;
                        continue block10;
                    }
                    currArg.append(c);
                    continue block10;
                }
                case 3: {
                    if (c == '\"') {
                        state = 1;
                        continue block10;
                    }
                    if (c == '\\') {
                        char next;
                        if ((next = arguments.charAt(++i)) == '\"' || next == '\\') {
                            currArg.append(next);
                            continue block10;
                        }
                        currArg.append(c);
                        currArg.append(next);
                        continue block10;
                    }
                    currArg.append(c);
                    continue block10;
                }
                case 0: 
                case 1: {
                    switch (c) {
                        case '\\': {
                            escaped = true;
                            state = 1;
                            continue block10;
                        }
                        case '\'': {
                            state = 2;
                            continue block10;
                        }
                        case '\"': {
                            state = 3;
                            continue block10;
                        }
                    }
                    if (!Character.isWhitespace(c)) {
                        currArg.append(c);
                        state = 1;
                        continue block10;
                    }
                    if (state != 1) continue block10;
                    argList.add(currArg.toString());
                    currArg = new StringBuilder();
                    state = 0;
                    continue block10;
                }
                default: {
                    throw new IllegalStateException("ArgumentTokenizer state " + state + " is invalid!");
                }
            }
        }
        if (escaped) {
            currArg.append('\\');
            argList.add(currArg.toString());
        } else if (state != 0) {
            argList.add(currArg.toString());
        }
        if (stringify) {
            for (i = 0; i < argList.size(); ++i) {
                argList.set(i, "\"" + ArgumentTokenizer._escapeQuotesAndBackslashes(argList.get(i)) + "\"");
            }
        }
        return argList;
    }

    protected static String _escapeQuotesAndBackslashes(String s) {
        StringBuilder buf = new StringBuilder(s);
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                buf.insert(i, '\\');
                continue;
            }
            if (c == '\n') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\n");
                continue;
            }
            if (c == '\t') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\t");
                continue;
            }
            if (c == '\r') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\r");
                continue;
            }
            if (c == '\b') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\b");
                continue;
            }
            if (c != '\f') continue;
            buf.deleteCharAt(i);
            buf.insert(i, "\\f");
        }
        return buf.toString();
    }
}

