/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.DefaultExecutionEvent;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ExecutionEventCatapult.class)
public class DefaultExecutionEventCatapult
implements ExecutionEventCatapult {
    @Override
    public void fire(ExecutionEvent.Type eventType, MavenSession session2, MojoExecution mojoExecution) {
        this.fire(eventType, session2, mojoExecution, null);
    }

    @Override
    public void fire(ExecutionEvent.Type eventType, MavenSession session2, MojoExecution mojoExecution, Exception exception) {
        ExecutionListener listener = session2.getRequest().getExecutionListener();
        if (listener != null) {
            DefaultExecutionEvent event2 = new DefaultExecutionEvent(eventType, session2, mojoExecution, exception);
            switch (eventType) {
                case ProjectDiscoveryStarted: {
                    listener.projectDiscoveryStarted(event2);
                    break;
                }
                case SessionStarted: {
                    listener.sessionStarted(event2);
                    break;
                }
                case SessionEnded: {
                    listener.sessionEnded(event2);
                    break;
                }
                case ProjectSkipped: {
                    listener.projectSkipped(event2);
                    break;
                }
                case ProjectStarted: {
                    listener.projectStarted(event2);
                    break;
                }
                case ProjectSucceeded: {
                    listener.projectSucceeded(event2);
                    break;
                }
                case ProjectFailed: {
                    listener.projectFailed(event2);
                    break;
                }
                case MojoSkipped: {
                    listener.mojoSkipped(event2);
                    break;
                }
                case MojoStarted: {
                    listener.mojoStarted(event2);
                    break;
                }
                case MojoSucceeded: {
                    listener.mojoSucceeded(event2);
                    break;
                }
                case MojoFailed: {
                    listener.mojoFailed(event2);
                    break;
                }
                case ForkStarted: {
                    listener.forkStarted(event2);
                    break;
                }
                case ForkSucceeded: {
                    listener.forkSucceeded(event2);
                    break;
                }
                case ForkFailed: {
                    listener.forkFailed(event2);
                    break;
                }
                case ForkedProjectStarted: {
                    listener.forkedProjectStarted(event2);
                    break;
                }
                case ForkedProjectSucceeded: {
                    listener.forkedProjectSucceeded(event2);
                    break;
                }
                case ForkedProjectFailed: {
                    listener.forkedProjectFailed(event2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown execution event type " + (Object)((Object)eventType));
                }
            }
        }
    }
}

