/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.soap11.decoder.http.impl;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.httpclient.BaseHttpClientResponseXMLMessageDecoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.common.SOAP11FaultDecodingException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.slf4j.Logger;

public class HttpClientResponseSOAP11Decoder
extends BaseHttpClientResponseXMLMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HttpClientResponseSOAP11Decoder.class);
    @NonnullAfterInit
    private MessageHandler bodyHandler;

    public HttpClientResponseSOAP11Decoder() {
        this.setProtocolMessageLoggerSubCategory("SOAP");
    }

    @NonnullAfterInit
    public MessageHandler getBodyHandler() {
        return this.bodyHandler;
    }

    public void setBodyHandler(@Nonnull MessageHandler newBodyHandler) {
        this.bodyHandler = Constraint.isNotNull(newBodyHandler, "MessageHandler cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.bodyHandler == null) {
            throw new ComponentInitializationException("Body handler MessageHandler cannot be null");
        }
    }

    @Override
    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        ClassicHttpResponse response = this.getHttpResponse();
        if (response == null) {
            throw new MessageDecodingException("No HttpResponse available");
        }
        this.log.debug("Unmarshalling SOAP message");
        try {
            int responseStatusCode = response.getCode();
            switch (responseStatusCode) {
                case 200: {
                    SOAP11Context soapContext = messageContext.ensureSubcontext(SOAP11Context.class);
                    this.processSuccessResponse(response, soapContext);
                    break;
                }
                case 500: {
                    throw this.buildFaultException(response);
                }
                default: {
                    throw new MessageDecodingException("Received non-success HTTP response status code from SOAP call: " + responseStatusCode);
                }
            }
        }
        catch (IOException e) {
            this.log.error("Unable to obtain input stream from HttpResponse: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Unable to obtain input stream from HttpResponse", e);
        }
        try {
            this.getBodyHandler().invoke(messageContext);
        }
        catch (MessageHandlerException e) {
            this.log.error("Error processing SOAP Envelope body: {}", (Object)e.getMessage());
            throw new MessageDecodingException("Error processing SOAP Envelope body", e);
        }
        if (messageContext.getMessage() == null) {
            this.log.warn("Body handler did not properly populate the message in message context");
            throw new MessageDecodingException("Body handler did not properly populate the message in message context");
        }
        this.setMessageContext(messageContext);
    }

    protected void processSuccessResponse(@Nonnull ClassicHttpResponse httpResponse, @Nonnull SOAP11Context soapContext) throws MessageDecodingException, IOException {
        try (HttpEntity entity = httpResponse.getEntity();){
            if (entity == null) {
                throw new MessageDecodingException("No response body from server");
            }
            Envelope soapMessage = (Envelope)this.unmarshallMessage(entity.getContent());
            Fault fault = this.getFault(soapMessage);
            if (fault != null) {
                throw new SOAP11FaultDecodingException(fault);
            }
            soapContext.setEnvelope(soapMessage);
            soapContext.setHTTPResponseStatus(httpResponse.getCode());
        }
    }

    @Nonnull
    protected MessageDecodingException buildFaultException(@Nonnull ClassicHttpResponse response) throws MessageDecodingException, IOException {
        try (HttpEntity entity = response.getEntity();){
            if (entity == null) {
                throw new MessageDecodingException("No response body from server");
            }
            Envelope soapMessage = (Envelope)this.unmarshallMessage(entity.getContent());
            Fault fault = this.getFault(soapMessage);
            if (fault == null) {
                throw new MessageDecodingException("HTTP status code was 500 but SOAP response contained no Fault");
            }
            FaultCode fcode = fault.getCode();
            QName code = fcode != null ? fcode.getValue() : null;
            FaultString fmsg = fault.getMessage();
            String msg = fmsg != null ? fmsg.getValue() : null;
            this.log.debug("SOAP fault code '{}' with message '{}'", (Object)(code != null ? code.toString() : "(not set)"), (Object)msg);
            SOAP11FaultDecodingException sOAP11FaultDecodingException = new SOAP11FaultDecodingException(fault);
            return sOAP11FaultDecodingException;
        }
    }

    @Nullable
    protected Fault getFault(@Nonnull Envelope soapMessage) {
        List<XMLObject> faults;
        Body body = soapMessage.getBody();
        if (body != null && !(faults = body.getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME)).isEmpty()) {
            return (Fault)faults.get(0);
        }
        return null;
    }

    @Override
    @Nullable
    protected XMLObject getMessageToLog() {
        MessageContext mc = this.getMessageContext();
        return mc != null ? mc.ensureSubcontext(SOAP11Context.class).getEnvelope() : null;
    }
}

