/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpRequestFormatter;
import org.apache.kafka.common.utils.Utils;

public class ClientCredentialsRequestFormatter
implements HttpRequestFormatter {
    public static final String GRANT_TYPE = "client_credentials";
    private final String clientId;
    private final String clientSecret;
    private final String scope;

    public ClientCredentialsRequestFormatter(String clientId, String clientSecret, String scope, boolean urlencode) {
        if (Utils.isBlank(clientId)) {
            throw new ConfigException("sasl.oauthbearer.client.credentials.client.id", clientId);
        }
        if (Utils.isBlank(clientSecret)) {
            throw new ConfigException("sasl.oauthbearer.client.credentials.client.secret", clientId);
        }
        clientId = clientId.trim();
        clientSecret = clientSecret.trim();
        String string = scope = Utils.isBlank(scope) ? null : scope.trim();
        if (urlencode) {
            clientId = URLEncoder.encode(clientId, StandardCharsets.UTF_8);
            clientSecret = URLEncoder.encode(clientSecret, StandardCharsets.UTF_8);
            if (scope != null) {
                scope = URLEncoder.encode(scope, StandardCharsets.UTF_8);
            }
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
    }

    @Override
    public Map<String, String> formatHeaders() {
        String s = String.format("%s:%s", this.clientId, this.clientSecret);
        String encoded = Base64.getEncoder().encodeToString(Utils.utf8(s));
        String authorizationHeader = String.format("Basic %s", encoded);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Authorization", authorizationHeader);
        headers.put("Cache-Control", "no-cache");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        return headers;
    }

    @Override
    public String formatBody() {
        StringBuilder requestParameters = new StringBuilder();
        requestParameters.append("grant_type=").append(GRANT_TYPE);
        if (this.scope != null) {
            requestParameters.append("&scope=").append(this.scope);
        }
        return requestParameters.toString();
    }
}

