/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.xhtml;

import java.awt.Color;
import java.util.EventListener;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.xhtml.XhtmlElTokenId;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public class XhtmlElHighlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener {
    private final Document document;
    private final AttributeSet expressionLanguageBackground;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;

    XhtmlElHighlighting(Document document) {
        Color elBC;
        this.document = document;
        AttributeSet elAttribs = null;
        String mimeType = (String)document.getProperty("mimeType");
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)mimeType).lookup(FontColorSettings.class);
        if (fcs != null && (elBC = XhtmlElHighlighting.getColoring(fcs, XhtmlElTokenId.EL.primaryCategory())) != null) {
            elAttribs = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, elBC, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE});
        }
        this.expressionLanguageBackground = elAttribs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        XhtmlElHighlighting xhtmlElHighlighting = this;
        synchronized (xhtmlElHighlighting) {
            if (this.expressionLanguageBackground != null) {
                if (this.hierarchy == null) {
                    this.hierarchy = TokenHierarchy.get((Document)this.document);
                    if (this.hierarchy != null) {
                        this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)((Object)this), this.hierarchy));
                    }
                }
                if (this.hierarchy != null) {
                    return new Highlights(this.version, this.hierarchy, startOffset, endOffset);
                }
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
        XhtmlElHighlighting xhtmlElHighlighting = this;
        synchronized (xhtmlElHighlighting) {
            ++this.version;
        }
        this.fireHighlightsChange(evt.affectedStartOffset(), evt.affectedEndOffset());
    }

    private static Color getColoring(FontColorSettings fcs, String tokenName) {
        AttributeSet as = fcs.getTokenFontColors(tokenName);
        if (as != null) {
            return (Color)as.getAttribute(StyleConstants.Background);
        }
        return null;
    }

    private class Highlights
    implements HighlightsSequence {
        private final long version;
        private final TokenHierarchy<?> scanner;
        private final int startOffset;
        private final int endOffset;
        private TokenSequence<?> sequence = null;
        private int sectionStart = -1;
        private int sectionEnd = -1;
        private boolean finished = false;
        private AttributeSet attributeSet;

        private Highlights(long version, TokenHierarchy<?> scanner, int startOffset, int endOffset) {
            this.version = version;
            this.scanner = scanner;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            XhtmlElHighlighting xhtmlElHighlighting = XhtmlElHighlighting.this;
            synchronized (xhtmlElHighlighting) {
                if (this.checkVersion()) {
                    if (this.sequence == null) {
                        if (!this.scanner.isActive()) {
                            return false;
                        }
                        this.sequence = this.scanner.tokenSequence();
                        this.sequence.move(this.startOffset);
                    }
                    while (this.sequence.moveNext() && this.sequence.offset() < this.endOffset) {
                        if (XhtmlElHighlighting.this.expressionLanguageBackground == null || this.sequence.token().id() != XhtmlElTokenId.EL) continue;
                        this.sectionStart = this.sequence.offset();
                        this.sectionEnd = this.sequence.offset() + this.sequence.token().length();
                        this.attributeSet = XhtmlElHighlighting.this.expressionLanguageBackground;
                        return true;
                    }
                }
                this.sectionStart = -1;
                this.sectionEnd = -1;
                this.finished = true;
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            XhtmlElHighlighting xhtmlElHighlighting = XhtmlElHighlighting.this;
            synchronized (xhtmlElHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return Math.max(this.sectionStart, this.startOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            XhtmlElHighlighting xhtmlElHighlighting = XhtmlElHighlighting.this;
            synchronized (xhtmlElHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return Math.min(this.sectionEnd, this.endOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            XhtmlElHighlighting xhtmlElHighlighting = XhtmlElHighlighting.this;
            synchronized (xhtmlElHighlighting) {
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                assert (this.sequence != null) : "Sequence not initialized, call moveNext() first.";
                return this.attributeSet;
            }
        }

        private boolean checkVersion() {
            return this.version == XhtmlElHighlighting.this.version;
        }
    }

    public static final class Factory
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)"el-embedded-xhtml-highlighting-layer", (ZOrder)ZOrder.BOTTOM_RACK.forPosition(150), (boolean)true, (HighlightsContainer)new XhtmlElHighlighting(context.getDocument()))};
        }
    }
}

