/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.openide.filesystems.FileObject;

public class ListenerGenerator {
    private final boolean isContext;
    private final boolean isContextAttr;
    private final boolean isSession;
    private final boolean isSessionAttr;
    private final boolean isRequest;
    private final boolean isRequestAttr;
    private GenerationUtils gu;

    public ListenerGenerator(boolean isContext, boolean isContextAttr, boolean isSession, boolean isSessionAttr, boolean isRequest, boolean isRequestAttr) {
        this.isContext = isContext;
        this.isContextAttr = isContextAttr;
        this.isSession = isSession;
        this.isSessionAttr = isSessionAttr;
        this.isRequest = isRequest;
        this.isRequestAttr = isRequestAttr;
    }

    public void generate(JavaSource clazz) throws IOException {
        Task task = workingCopy -> {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cut = workingCopy.getCompilationUnit();
            this.gu = GenerationUtils.newInstance((WorkingCopy)workingCopy);
            for (Tree tree : cut.getTypeDecls()) {
                Element e;
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || (e = workingCopy.getTrees().getElement(new TreePath(new TreePath(workingCopy.getCompilationUnit()), tree))) == null || !e.getKind().isClass()) continue;
                TypeElement te = (TypeElement)e;
                ClassTree ct = (ClassTree)tree;
                workingCopy.rewrite((Tree)ct, (Tree)this.generateInterfaces((WorkingCopy)workingCopy, te, ct, this.gu, clazz));
            }
        };
        ModificationResult result = clazz.runModificationTask(task);
        result.commit();
    }

    private ClassTree generateInterfaces(WorkingCopy wc, TypeElement te, ClassTree ct, GenerationUtils gu, JavaSource clazz) {
        String prefix;
        ClassTree newClassTree = ct;
        ArrayList<String> ifList = new ArrayList<String>();
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        FileObject jakartaServletRequestListenerFo = clazz.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE).findResource("jakarta" + ".servlet.ServletRequestListener".replace('.', '/') + ".class");
        String string = prefix = jakartaServletRequestListenerFo == null ? "javax" : "jakarta";
        if (this.isContext) {
            ifList.add(prefix + ".servlet.ServletContextListener");
        }
        if (this.isContextAttr) {
            ifList.add(prefix + ".servlet.ServletContextAttributeListener");
        }
        if (this.isSession) {
            ifList.add(prefix + ".servlet.http.HttpSessionListener");
        }
        if (this.isSessionAttr) {
            ifList.add(prefix + ".servlet.http.HttpSessionAttributeListener");
        }
        if (this.isRequest) {
            ifList.add(prefix + ".servlet.ServletRequestListener");
        }
        if (this.isRequestAttr) {
            ifList.add(prefix + ".servlet.ServletRequestAttributeListener");
        }
        for (String ifName : ifList) {
            newClassTree = gu.addImplementsClause(newClassTree, ifName);
            TypeElement typeElement = wc.getElements().getTypeElement(ifName);
            methods.addAll(ElementFilter.methodsIn(typeElement.getEnclosedElements()));
        }
        for (MethodTree t : GeneratorUtilities.get((WorkingCopy)wc).createAbstractMethodImplementations(te, methods)) {
            newClassTree = GeneratorUtilities.get((WorkingCopy)wc).insertClassMember(newClassTree, (Tree)t);
        }
        return newClassTree;
    }
}

