/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.actions;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.javafx2.editor.completion.model.EventHandler;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxInclude;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxObjectBase;
import org.netbeans.modules.javafx2.editor.completion.model.FxmlParserResult;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class ControllerGenerator
implements Task<WorkingCopy> {
    private FxmlParserResult fxmlSource;
    private WorkingCopy wcopy;
    private DataObject controllerSource;
    private ClassTree controllerClass;
    private ClassTree origController;
    private TypeElement fxmlAnnotationType;
    private AnnotationTree fxmlAnnotationTree;
    private Map<String, Object> methods = new HashMap<String, Object>();
    private Map<String, Collection<TypeMirror>> generatedMethods = new HashMap<String, Collection<TypeMirror>>();
    private Map<String, TypeMirror> generatedFields = new HashMap<String, TypeMirror>();
    private Map<String, VariableTree> fields = new HashMap<String, VariableTree>();
    private Set<Tree> mappedTrees = new HashSet<Tree>();
    private TreePath controllerPath;
    private GeneratorUtilities genUtils;

    public ControllerGenerator(FxmlParserResult fxmlSource, DataObject controllerSource) {
        this.fxmlSource = fxmlSource;
        this.controllerSource = controllerSource;
    }

    public void run(WorkingCopy parameter) throws Exception {
        this.wcopy = parameter;
        parameter.toPhase(JavaSource.Phase.RESOLVED);
        this.fxmlAnnotationType = this.wcopy.getElements().getTypeElement("javafx.fxml.FXML");
        if (this.fxmlAnnotationType == null) {
            throw new ParseException("FXML libraries not on classpath");
        }
        this.fxmlAnnotationTree = this.wcopy.getTreeMaker().Annotation(this.wcopy.getTreeMaker().Type(this.fxmlAnnotationType.asType()), Collections.emptyList());
        List<? extends Tree> types = parameter.getCompilationUnit().getTypeDecls();
        for (Tree tree : types) {
            ClassTree ct;
            if (tree.getKind() != Tree.Kind.CLASS || !(ct = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC) || !ct.getSimpleName().toString().equals(parameter.getSnapshot().getSource().getFileObject().getName())) continue;
            this.controllerClass = ct;
        }
        if (this.controllerClass == null) {
            throw new UnsupportedOperationException("Controller class not found");
        }
        this.origController = this.controllerClass;
        this.wcopy.getTrees().getDocComment(this.getControllerPath());
        this.indexController();
        this.fxmlSource.getSourceModel().accept(new UpdatingVisitor());
        this.cleanUnused();
        this.wcopy.rewrite((Tree)this.origController, (Tree)this.controllerClass);
    }

    private void indexController() {
        for (Tree tree : this.controllerClass.getMembers()) {
            switch (tree.getKind()) {
                case VARIABLE: {
                    VariableTree vt = (VariableTree)tree;
                    this.fields.put(vt.getName().toString(), vt);
                    break;
                }
                case METHOD: {
                    MethodTree mt = (MethodTree)tree;
                    this.addMethod(mt);
                    break;
                }
            }
        }
    }

    private void addMethod(MethodTree mt) {
        String key = mt.getName().toString();
        Object old = this.methods.get(key);
        if (old == null) {
            this.methods.put(key, mt);
        } else {
            ArrayList<MethodTree> c;
            if (old instanceof Collection) {
                c = (ArrayList<MethodTree>)old;
            } else {
                c = new ArrayList<MethodTree>();
                this.methods.put(key, c);
                c.add((MethodTree)old);
            }
            c.add(mt);
        }
    }

    private TypeElement getInstanceType(FxInstance decl) {
        ElementHandle<TypeElement> compType = decl.getJavaType();
        if (compType == null) {
            return null;
        }
        TypeElement tel = (TypeElement)compType.resolve((CompilationInfo)this.wcopy);
        return tel;
    }

    private TreePath getControllerPath() {
        if (this.controllerPath == null) {
            this.controllerPath = new TreePath(new TreePath(this.wcopy.getCompilationUnit()), this.origController);
        }
        return this.controllerPath;
    }

    private void addMethod(String name, TypeMirror parameter) {
        Collection<TypeMirror> param = this.generatedMethods.get(name);
        if (param == null) {
            param = new LinkedList<TypeMirror>();
            this.generatedMethods.put(name, param);
        }
        for (TypeMirror tm : param) {
            if (!this.wcopy.getTypes().isSameType(tm, parameter)) continue;
            throw new IllegalStateException();
        }
        param.add(parameter);
    }

    private boolean isGenerated(String name, TypeMirror paramType) {
        Collection<TypeMirror> param = this.generatedMethods.get(name);
        if (param == null) {
            return false;
        }
        for (TypeMirror tm : param) {
            if (!this.wcopy.getTypes().isSameType(tm, paramType)) continue;
            return true;
        }
        return false;
    }

    private void syncEventHandler(EventHandler h) {
        Set<MethodTree> overloads;
        String n = h.getHandlerName().toString();
        if (h.getEventInfo() == null || h.getEventInfo().getEventType() == null) {
            return;
        }
        TypeElement eventType = (TypeElement)h.getEventInfo().getEventType().resolve((CompilationInfo)this.wcopy);
        if (eventType == null) {
            return;
        }
        if (this.isGenerated(n, eventType.asType())) {
            return;
        }
        Object o = this.methods.get(n);
        if (o instanceof Collection) {
            overloads = (Set<MethodTree>)o;
        } else if (o != null) {
            overloads = Collections.singleton((MethodTree)o);
        } else {
            this.defineNewHandler(h.getHandlerName(), eventType);
            return;
        }
        ExecutableElement handlerElement = null;
        ExecutableElement handlerElementNoArg = null;
        for (MethodTree mt : overloads) {
            TreePath mPath = new TreePath(this.getControllerPath(), mt);
            ExecutableElement e = (ExecutableElement)this.wcopy.getTrees().getElement(mPath);
            if (e.getParameters().isEmpty()) {
                handlerElementNoArg = e;
                break;
            }
            if (e.getParameters().size() != 1) continue;
            VariableElement param = e.getParameters().get(0);
            if (!this.wcopy.getTypes().isAssignable(eventType.asType(), param.asType())) continue;
            handlerElement = e;
            break;
        }
        if (handlerElement == null) {
            handlerElement = handlerElementNoArg;
        }
        if (handlerElement == null) {
            this.defineNewHandler(n, eventType);
        } else {
            MethodTree handlerTree = this.wcopy.getTrees().getTree(handlerElement);
            this.mappedTrees.add(handlerTree);
            AnnotationTree ann = this.findFxmlAnnotation(handlerTree.getModifiers());
            if (ann == null) {
                TreeMaker mk = this.wcopy.getTreeMaker();
                this.wcopy.rewrite((Tree)handlerTree.getModifiers(), (Tree)mk.addModifiersAnnotation(handlerTree.getModifiers(), this.fxmlAnnotationTree));
            }
        }
    }

    private void defineNewHandler(CharSequence handlerName, TypeElement eventType) {
        TreeMaker mk = this.wcopy.getTreeMaker();
        MethodTree handler = mk.Method(mk.Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(this.fxmlAnnotationTree)), handlerName, (Tree)mk.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(mk.Variable(mk.Modifiers(Collections.emptySet()), (CharSequence)"event", mk.Type(eventType.asType()), null)), Collections.emptyList(), mk.Block(Collections.emptyList(), false), null);
        this.controllerClass = this.genUtils().insertClassMember(this.controllerClass, (Tree)handler);
        this.addMethod(handlerName.toString(), eventType.asType());
    }

    private GeneratorUtilities genUtils() {
        if (this.genUtils == null) {
            this.genUtils = GeneratorUtilities.get((WorkingCopy)this.wcopy);
        }
        return this.genUtils;
    }

    static TypeMirror eraseFieldTypeParameters(TypeMirror tm, CompilationInfo cinfo) {
        Boolean shouldReplace = tm.accept(new SimpleTypeVisitor6<Boolean, Void>(){

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Void p) {
                return false;
            }

            @Override
            public Boolean visitNull(NullType t, Void p) {
                return false;
            }

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return (Boolean)this.visit(t.getComponentType());
            }

            @Override
            public Boolean visitDeclared(DeclaredType t, Void p) {
                return !t.getTypeArguments().isEmpty();
            }

            @Override
            public Boolean visitNoType(NoType t, Void p) {
                return false;
            }
        }, null);
        if (Boolean.TRUE.equals(shouldReplace)) {
            return tm.accept(new FieldTParamEraser(), cinfo);
        }
        return tm;
    }

    private void syncComponentBinding(FxInstance decl) {
        String id = decl.getId();
        TypeElement declType = this.getInstanceType(decl);
        TypeMirror fieldType = this.generatedFields.get(id);
        if (fieldType != null) {
            return;
        }
        VariableTree vt = this.fields.get(id);
        if (vt == null) {
            if (declType == null) {
                return;
            }
            this.defineNewField(id, this.wcopy.getTreeMaker().Type(ControllerGenerator.eraseFieldTypeParameters(declType.asType(), (CompilationInfo)this.wcopy)));
            this.generatedFields.put(id, declType.asType());
            return;
        }
        TreePath varPath = new TreePath(this.getControllerPath(), vt);
        VariableElement e = (VariableElement)this.wcopy.getTrees().getElement(varPath);
        if (e == null) {
            throw new IllegalStateException();
        }
        if (declType != null && !this.wcopy.getTypes().isAssignable(this.wcopy.getTypes().erasure(declType.asType()), this.wcopy.getTypes().erasure(e.asType()))) {
            this.wcopy.rewrite(vt.getType(), this.wcopy.getTreeMaker().Type(ControllerGenerator.eraseFieldTypeParameters(declType.asType(), (CompilationInfo)this.wcopy)));
        }
        if (!FxClassUtils.isFxmlAccessible(e)) {
            this.wcopy.rewrite((Tree)vt.getModifiers(), (Tree)this.wcopy.getTreeMaker().addModifiersAnnotation(vt.getModifiers(), this.fxmlAnnotationTree));
        }
        this.mappedTrees.add(vt);
        TypeMirror v = declType != null ? declType.asType() : e.asType();
        this.generatedFields.put(id, v);
    }

    private void defineNewField(String name, Tree typeTree) {
        TreeMaker make = this.wcopy.getTreeMaker();
        VariableTree newVar = make.Variable(make.Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(this.fxmlAnnotationTree)), (CharSequence)name, typeTree, null);
        this.controllerClass = GeneratorUtilities.get((WorkingCopy)this.wcopy).insertClassMember(this.controllerClass, (Tree)newVar);
    }

    private AnnotationTree findFxmlAnnotation(ModifiersTree modTree) {
        for (AnnotationTree annotationTree : modTree.getAnnotations()) {
            TreePath tp = new TreePath(new TreePath(this.wcopy.getCompilationUnit()), annotationTree.getAnnotationType());
            Element e = this.wcopy.getTrees().getElement(tp);
            if (!this.fxmlAnnotationType.equals(e)) continue;
            return annotationTree;
        }
        return null;
    }

    private void cleanField(VariableTree mt) {
        AnnotationTree t = this.findFxmlAnnotation(mt.getModifiers());
        if (t == null) {
            return;
        }
        if (!this.isUsed(mt, mt.getModifiers())) {
            this.controllerClass = this.wcopy.getTreeMaker().removeClassMember(this.controllerClass, (Tree)mt);
            return;
        }
        this.wcopy.rewrite((Tree)mt.getModifiers(), (Tree)this.wcopy.getTreeMaker().removeModifiersAnnotation(mt.getModifiers(), t));
    }

    private void cleanMethod(MethodTree mt) {
        AnnotationTree t = this.findFxmlAnnotation(mt.getModifiers());
        if (t == null) {
            return;
        }
        if (!this.isUsed(mt, mt.getModifiers()) && mt.getBody().getStatements().isEmpty()) {
            this.controllerClass = this.wcopy.getTreeMaker().removeClassMember(this.controllerClass, (Tree)mt);
            return;
        }
        this.wcopy.rewrite((Tree)mt.getModifiers(), (Tree)this.wcopy.getTreeMaker().removeModifiersAnnotation(mt.getModifiers(), t));
    }

    private void cleanUnused() {
        for (Tree tree : this.origController.getMembers()) {
            if (this.mappedTrees.contains(tree)) continue;
            switch (tree.getKind()) {
                case METHOD: {
                    this.cleanMethod((MethodTree)tree);
                    break;
                }
                case VARIABLE: {
                    this.cleanField((VariableTree)tree);
                }
            }
        }
    }

    private boolean isUsed(Tree memberTree, ModifiersTree mods) {
        if (!mods.getFlags().contains((Object)Modifier.PRIVATE)) {
            return true;
        }
        TreePath t = new TreePath(this.getControllerPath(), memberTree);
        TreePathHandle hnd = TreePathHandle.create((TreePath)t, (CompilationInfo)this.wcopy);
        WhereUsedQuery a = new WhereUsedQuery(Lookups.fixed((Object[])new Object[]{hnd}));
        RefactoringSession session = RefactoringSession.create((String)"Find usages");
        a.prepare(session);
        boolean used = !session.getRefactoringElements().isEmpty();
        session.finished();
        return used;
    }

    static void generateControllerAttribute(final Source s, final String className) throws ParseException {
        final int[] positions = new int[2];
        ParserManager.parse(Collections.singleton(s), (UserTask)new UserTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ResultIterator resultIterator) throws Exception {
                final FxmlParserResult fxResult = FxmlParserResult.get(resultIterator.getParserResult());
                FxModel model = fxResult.getSourceModel();
                FxObjectBase root = fxResult.getSourceModel().getRootComponent();
                if (root == null) {
                    return;
                }
                TextPositions poss = fxResult.getTreeUtilities().positions(root);
                positions[0] = poss.getStart();
                positions[1] = poss.getContentStart();
                Document d = s.getDocument(true);
                final ClasspathInfo cpInfo = ClasspathInfo.create((Document)d);
                int dot = className.lastIndexOf(46);
                final String simpleName = className.substring(dot + 1);
                final String[] sourceName = new String[1];
                class UT
                extends UserTask
                implements ClasspathInfoProvider {
                    final /* synthetic */ 2 this$0;

                    UT() {
                        this.this$0 = this$0;
                    }

                    public void run(ResultIterator resultIterator) throws Exception {
                        String s;
                        CompilationInfo ci = CompilationInfo.get((Parser.Result)resultIterator.getParserResult());
                        Set<String> classes = fxResult.resolveClassName(ci, simpleName);
                        sourceName[0] = classes == null || classes.size() != 1 ? className : ((s = classes.iterator().next()).equals(className) ? simpleName : className);
                    }

                    public ClasspathInfo getClasspathInfo() {
                        return cpInfo;
                    }
                }
                ParserManager.parse((String)"text/x-java", (UserTask)new UT());
                BaseDocument bd = (BaseDocument)d;
                bd.extWriteLock();
                try {
                    if (model.getController() != null) {
                        int[] positions2 = fxResult.getTreeUtilities().findAttributePos(root, "http://javafx.com/fxml", "controller", true);
                        d.remove(positions2[0], positions2[1] - positions2[0]);
                        d.insertString(positions2[0], sourceName[0], null);
                    } else {
                        ControllerGenerator.addControllerAttribute(bd, positions[0], positions[1], sourceName[0]);
                    }
                }
                finally {
                    bd.extWriteUnlock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addControllerAttribute(BaseDocument doc, int from, int to, String controllerClassName) throws BadLocationException {
        doc.extWriteLock();
        try {
            TokenHierarchy h = TokenHierarchy.get((Document)doc);
            TokenSequence seq = h.tokenSequence();
            seq.move(from);
            int lastWsPos = -1;
            int start = -1;
            while (seq.moveNext()) {
                Token t = seq.token();
                XMLTokenId id = (XMLTokenId)t.id();
                if (seq.offset() >= to) {
                    start = seq.offset();
                    break;
                }
                if (id == XMLTokenId.WS) {
                    lastWsPos = seq.offset() + 1;
                    continue;
                }
                if (id == XMLTokenId.TAG) {
                    if (t.text().length() <= 0 || t.text().charAt(t.text().length() - 1) != '>') continue;
                    start = seq.offset();
                    break;
                }
                lastWsPos = -1;
            }
            String toInsert = "fx:controller=\"" + controllerClassName + "\"";
            if (lastWsPos != -1) {
                start = lastWsPos;
            } else {
                toInsert = " " + toInsert;
            }
            doc.insertString(start, toInsert, null);
        }
        finally {
            doc.extWriteUnlock();
        }
    }

    private class UpdatingVisitor
    extends FxNodeVisitor.ModelTraversal {
        private UpdatingVisitor() {
        }

        @Override
        public void visitInclude(FxInclude decl) {
            if (decl.getId() != null && Utilities.isJavaIdentifier((String)decl.getId()) && decl.getRoot().getInstance(decl.getId()) == decl) {
                ControllerGenerator.this.syncComponentBinding(decl);
            }
            super.visitInclude(decl);
        }

        @Override
        public void visitBaseInstance(FxInstance decl) {
            if (decl.getId() != null && Utilities.isJavaIdentifier((String)decl.getId()) && decl.getRoot().getInstance(decl.getId()) == decl) {
                ControllerGenerator.this.syncComponentBinding(decl);
            }
            super.visitBaseInstance(decl);
        }

        @Override
        public void visitEvent(EventHandler eh) {
            if (!eh.isScript()) {
                ControllerGenerator.this.syncEventHandler(eh);
            }
            super.visitEvent(eh);
        }
    }

    private static class FieldTParamEraser
    extends SimpleTypeVisitor6<TypeMirror, CompilationInfo> {
        private FieldTParamEraser() {
        }

        @Override
        public TypeMirror visitArray(ArrayType t, CompilationInfo p) {
            TypeMirror component = (TypeMirror)this.visit(t.getComponentType(), p);
            return p.getTypes().getArrayType(component);
        }

        @Override
        public TypeMirror visitDeclared(DeclaredType t, CompilationInfo p) {
            if (t.getTypeArguments().isEmpty()) {
                return t;
            }
            ArrayList<TypeMirror> newArgs = new ArrayList<TypeMirror>(t.getTypeArguments().size());
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                newArgs.add((TypeMirror)this.visit(typeMirror, p));
            }
            TypeMirror enclosing = t.getEnclosingType();
            if (enclosing != null) {
                enclosing = (TypeMirror)this.visit(enclosing, p);
            }
            return p.getTypes().getDeclaredType((DeclaredType)enclosing, (TypeElement)t.asElement(), newArgs.toArray(new TypeMirror[0]));
        }

        @Override
        public TypeMirror visitTypeVariable(TypeVariable t, CompilationInfo p) {
            TypeMirror ub;
            TypeMirror lb = t.getLowerBound() == null ? null : (TypeMirror)this.visit(t.getLowerBound(), p);
            TypeMirror typeMirror = ub = t.getUpperBound() == null ? null : (TypeMirror)this.visit(t.getUpperBound(), p);
            if (ub.getKind() == TypeKind.DECLARED) {
                DeclaredType dt = (DeclaredType)ub;
                TypeElement tel = (TypeElement)dt.asElement();
                if (tel.getQualifiedName().contentEquals("java.lang.Object")) {
                    ub = null;
                } else if (tel.getSimpleName().length() == 0) {
                    ub = null;
                }
            }
            return p.getTypes().getWildcardType(ub, lb);
        }
    }
}

