/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.JButton;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.Bundle;
import org.netbeans.modules.java.hints.introduce.InstanceRefFinder;
import org.netbeans.modules.java.hints.introduce.IntroduceFixBase;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceMethodPanel;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.MethodValidator;
import org.netbeans.modules.java.hints.introduce.ReferenceTransformer;
import org.netbeans.modules.java.hints.introduce.TargetDescription;
import org.netbeans.modules.java.hints.introduce.TreeUtils;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

final class IntroduceExpressionBasedMethodFix
extends IntroduceFixBase
implements Fix {
    private final TypeMirrorHandle returnType;
    private final List<TreePathHandle> parameters;
    private final Set<TypeMirrorHandle> thrownTypes;
    private final List<TreePathHandle> typeVars;
    private final Collection<TargetDescription> targets;

    static List<TargetDescription> computeViableTargets(CompilationInfo info, TreePath commonParent, Iterable<? extends Tree> toInclude, Iterable<? extends Occurrence> duplicates, AtomicBoolean cancel, AtomicBoolean allIfaces) {
        ArrayList<TargetDescription> targets = new ArrayList<TargetDescription>();
        boolean allInterfaces = true;
        for (TreePath acceptableParent = commonParent; acceptableParent != null; acceptableParent = acceptableParent.getParentPath()) {
            Object el;
            if (cancel.get()) {
                return null;
            }
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)acceptableParent.getLeaf().getKind())) continue;
            boolean duplicatesAcceptable = true;
            block1: for (Occurrence occurrence : duplicates) {
                for (Tree t : occurrence.getOccurrenceRoot()) {
                    if (t != acceptableParent.getLeaf()) continue;
                    continue block1;
                }
                duplicatesAcceptable = false;
                break;
            }
            if ((el = info.getTrees().getElement(acceptableParent)) == null) continue;
            boolean bl = el.getKind().isInterface();
            if (!el.getKind().isClass() && !bl) continue;
            TargetDescription td = TargetDescription.create(info, (TypeElement)el, acceptableParent, duplicatesAcceptable, bl);
            if (td.type != null && td.type.resolve(info) != null) {
                targets.add(td);
            }
            allInterfaces &= bl;
        }
        Collections.reverse(targets);
        InstanceRefFinder finder = new InstanceRefFinder(info, commonParent);
        for (Tree tree : toInclude) {
            finder.process(new TreePath(commonParent, tree));
        }
        Set<Element> usedMembers = finder.getUsedMembers();
        Set<TypeElement> set = finder.getRequiredInstances();
        Iterator it = targets.iterator();
        while (!(!it.hasNext() || usedMembers.isEmpty() && set.isEmpty())) {
            TargetDescription td = (TargetDescription)it.next();
            TypeElement type = (TypeElement)td.type.resolve(info);
            if (type == null) {
                it.remove();
                continue;
            }
            usedMembers.removeAll(info.getElements().getAllMembers(type));
            set.remove(type);
            if (!usedMembers.isEmpty() || !set.isEmpty()) {
                it.remove();
                continue;
            }
            allInterfaces &= type.getKind() == ElementKind.INTERFACE;
        }
        if (targets.isEmpty()) {
            TreePath clazz = TreeUtils.findClass(commonParent);
            Element el = info.getTrees().getElement(clazz);
            if (el == null || !el.getKind().isClass() && !el.getKind().isInterface()) {
                return null;
            }
            allInterfaces = el.getKind().isInterface();
            targets.add(TargetDescription.create(info, (TypeElement)el, clazz, true, el.getKind().isInterface()));
        }
        allIfaces.set(allInterfaces);
        return targets;
    }

    public IntroduceExpressionBasedMethodFix(Source source, TreePathHandle expression, List<TreePathHandle> parameters, TypeMirrorHandle returnType, Set<TypeMirrorHandle> thrownTypes, int duplicatesCount, List<TreePathHandle> typeVars, int offset, Collection<TargetDescription> targets) {
        super(source, expression, duplicatesCount, offset);
        this.parameters = parameters;
        this.thrownTypes = thrownTypes;
        this.typeVars = typeVars;
        this.targets = targets;
        this.returnType = returnType;
    }

    public String getText() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceMethod");
    }

    public String toString() {
        return "[IntroduceExpressionBasedMethodFix]";
    }

    public ChangeInfo implement() throws Exception {
        JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
        JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
        btnCancel.setDefaultCapable(false);
        IntroduceMethodPanel panel = new IntroduceMethodPanel("method", this.duplicatesCount, this.targets, this.targetIsInterface);
        String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
        NotificationLineSupport notifier = dd.createNotificationLineSupport();
        MethodValidator val = new MethodValidator(this.source, this.parameters, this.returnType);
        panel.setNotifier(notifier);
        panel.setValidator(val);
        panel.setOkButton(btnOk);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
            return null;
        }
        String name = panel.getMethodName();
        Set<Modifier> access = panel.getAccess();
        boolean replaceOther = panel.getReplaceOther();
        TargetDescription target = panel.getSelectedTarget();
        MemberSearchResult searchResult = val.getResult();
        boolean redoReferences = panel.isRefactorExisting();
        this.getModificationResult(name, target, replaceOther, access, redoReferences, searchResult).commit();
        return null;
    }

    @Override
    public ModificationResult getModificationResult() throws ParseException {
        ModificationResult result = null;
        int counter = 0;
        do {
            try {
                result = this.getModificationResult("method" + (counter != 0 ? String.valueOf(counter) : ""), this.targets.iterator().next(), true, EnumSet.of(Modifier.PRIVATE), false, null);
            }
            catch (Exception e) {
                ++counter;
            }
        } while (result == null && counter < 10);
        return result;
    }

    private ModificationResult getModificationResult(final String name, final TargetDescription target, final boolean replaceOther, final Set<Modifier> access, final boolean redoReferences, final MemberSearchResult searchResult) throws ParseException {
        return ModificationResult.runModificationTask(Collections.singleton(this.source), (UserTask)new UserTask(this){
            final /* synthetic */ IntroduceExpressionBasedMethodFix this$0;
            {
                this.this$0 = this$0;
            }

            public void run(ResultIterator resultIterator) throws Exception {
                TreePath pathToClass;
                TypeMirror returnType;
                WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                copy.toPhase(JavaSource.Phase.RESOLVED);
                TreePath expression = this.this$0.handle.resolve((CompilationInfo)copy);
                InstanceRefFinder finder = new InstanceRefFinder((CompilationInfo)copy, expression);
                finder.process();
                if (finder.containsLocalReferences()) {
                    NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)Bundle.MSG_ExpressionContainsLocalReferences(), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)dd);
                    return;
                }
                boolean referencesInstances = finder.containsInstanceReferences();
                TypeMirror typeMirror = returnType = expression != null ? IntroduceHint.resolveType((CompilationInfo)copy, expression) : null;
                if (expression == null || returnType == null) {
                    return;
                }
                returnType = Utilities.convertIfAnonymous(Utilities.resolveTypeForDeclaration((CompilationInfo)copy, returnType));
                TreeMaker make = copy.getTreeMaker();
                Tree returnTypeTree = make.Type(returnType);
                copy.tag(returnTypeTree, (Object)"typeTag");
                List<VariableElement> parameters = IntroduceHint.resolveVariables((CompilationInfo)copy, this.this$0.parameters);
                List<ExpressionTree> realArguments = IntroduceHint.realArguments(make, parameters);
                MethodInvocationTree invocation = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)name), realArguments);
                TypeElement targetType = (TypeElement)target.type.resolve((CompilationInfo)copy);
                TreePath treePath = pathToClass = targetType != null ? copy.getTrees().getPath(targetType) : null;
                if (pathToClass == null) {
                    pathToClass = TreeUtils.findClass(expression);
                }
                assert (pathToClass != null);
                List<VariableTree> formalArguments = IntroduceHint.createVariables(copy, parameters, pathToClass, Collections.singletonList(expression));
                if (formalArguments == null) {
                    return;
                }
                List<ExpressionTree> thrown = IntroduceHint.typeHandleToTree(copy, this.this$0.thrownTypes);
                if (this.this$0.thrownTypes == null) {
                    return;
                }
                LinkedList<ReturnTree> methodStatements = new LinkedList<ReturnTree>();
                methodStatements.add(make.Return((ExpressionTree)expression.getLeaf()));
                LinkedList<TypeParameterTree> typeVars = new LinkedList<TypeParameterTree>();
                for (TreePathHandle tph : this.this$0.typeVars) {
                    typeVars.add((TypeParameterTree)tph.resolve((CompilationInfo)copy).getLeaf());
                }
                boolean isStatic = !referencesInstances || IntroduceHint.needsStaticRelativeTo((CompilationInfo)copy, pathToClass, expression);
                Tree parentTree = expression.getParentPath().getLeaf();
                Tree nueParent = copy.getTreeUtilities().translate(parentTree, Collections.singletonMap(expression.getLeaf(), invocation));
                copy.rewrite(parentTree, nueParent);
                if (replaceOther) {
                    Document doc = copy.getDocument();
                    Pattern p = Pattern.createPatternWithRemappableVariables((TreePath)expression, parameters, (boolean)true);
                    for (Occurrence desc : Matcher.create((CompilationInfo)copy).setSearchRoot(pathToClass).setCancel(new AtomicBoolean()).match(p)) {
                        TreePath firstLeaf = desc.getOccurrenceRoot();
                        int startOff = (int)copy.getTrees().getSourcePositions().getStartPosition(copy.getCompilationUnit(), firstLeaf.getLeaf());
                        int endOff = (int)copy.getTrees().getSourcePositions().getEndPosition(copy.getCompilationUnit(), firstLeaf.getLeaf());
                        if (!GraphicsEnvironment.isHeadless() && !IntroduceHint.shouldReplaceDuplicate(doc, startOff, endOff)) continue;
                        LinkedList<Union2<VariableElement, TreePath>> dupeParameters = new LinkedList<Union2<VariableElement, TreePath>>();
                        for (VariableElement ve : parameters) {
                            if (desc.getVariablesRemapToTrees().containsKey(ve)) {
                                dupeParameters.add((Union2<VariableElement, TreePath>)Union2.createSecond((Object)((TreePath)desc.getVariablesRemapToTrees().get(ve))));
                                continue;
                            }
                            dupeParameters.add((Union2<VariableElement, TreePath>)Union2.createFirst((Object)ve));
                        }
                        List<ExpressionTree> dupeRealArguments = IntroduceHint.realArgumentsForTrees(make, dupeParameters);
                        MethodInvocationTree dupeInvocation = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)name), dupeRealArguments);
                        copy.rewrite(firstLeaf.getLeaf(), (Tree)dupeInvocation);
                        isStatic |= IntroduceHint.needsStaticRelativeTo((CompilationInfo)copy, pathToClass, firstLeaf);
                    }
                    IntroduceHint.introduceBag(doc).clear();
                }
                EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
                if (target.iface) {
                    modifiers.add(Modifier.DEFAULT);
                } else if (isStatic && target.canStatic) {
                    modifiers.add(Modifier.STATIC);
                }
                modifiers.addAll(access);
                ModifiersTree mods = make.Modifiers(modifiers);
                MethodTree method = make.Method(mods, (CharSequence)name, returnTypeTree, typeVars, formalArguments, thrown, make.Block(methodStatements, false), null);
                ClassTree nueClass = IntroduceHint.INSERT_CLASS_MEMBER.insertClassMember(copy, (ClassTree)pathToClass.getLeaf(), method, this.this$0.offset);
                copy.rewrite(pathToClass.getLeaf(), (Tree)nueClass);
                if (redoReferences) {
                    new ReferenceTransformer(copy, ElementKind.METHOD, searchResult, name, targetType).scan(pathToClass, null);
                }
            }
        });
    }
}

