/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.LocationCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class StopwatchCustomizer
extends ValidityAwarePanel
implements DocumentListener,
ChangeListener,
ValidityListener,
HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "StopwatchCustomizer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("StopwatchCustomizer.HelpCtx");
    private static int defaultTextComponentHeight = -1;
    private JLabel captionLabel;
    private JLabel locationBeginHeaderLabel;
    private JLabel locationEndHeaderLabel;
    private JLabel measureLabel;
    private JLabel nameLabel;
    private JLabel settingsHeaderLabel;
    private JPanel captionPanel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton measureTimestampDurationRadio;
    private JRadioButton measureTimestampRadio;
    private JSeparator locationBeginHeaderSeparator;
    private JSeparator locationEndHeaderSeparator;
    private JSeparator settingsHeaderSeparator;
    private JTextField nameTextField;
    private LocationCustomizer locationBeginCustomizer;
    private LocationCustomizer locationEndCustomizer;

    public StopwatchCustomizer(String caption, Icon icon) {
        this.initComponents(caption, icon);
        this.normalizeCaptionAreaWidth();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    public Component getInitialFocusTarget() {
        return this.nameTextField;
    }

    public void setPPEndLocation(CodeProfilingPoint.Location location) {
        if (location == null) {
            this.measureTimestampRadio.setSelected(true);
            this.locationEndCustomizer.setPPLocation(CodeProfilingPoint.Location.EMPTY);
        } else {
            this.measureTimestampDurationRadio.setSelected(true);
            this.locationEndCustomizer.setPPLocation(location);
        }
    }

    public CodeProfilingPoint.Location getPPEndLocation() {
        if (this.measureTimestampRadio.isSelected()) {
            return null;
        }
        return this.locationEndCustomizer.getPPLocation();
    }

    public void setPPName(String name) {
        this.nameTextField.setText(name);
    }

    public String getPPName() {
        return this.nameTextField.getText();
    }

    public void setPPStartLocation(CodeProfilingPoint.Location location) {
        this.locationBeginCustomizer.setPPLocation(location);
    }

    public CodeProfilingPoint.Location getPPStartLocation() {
        return this.locationBeginCustomizer.getPPLocation();
    }

    public int getPreferredCaptionAreaWidth() {
        int ownCaptionAreaWidth = this.nameLabel.getPreferredSize().width - 12;
        return Math.max(ownCaptionAreaWidth, this.locationBeginCustomizer.getPreferredCaptionAreaWidth());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public void initComponents(String caption, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.captionPanel = new JPanel(new BorderLayout(0, 0));
        this.captionPanel.setOpaque(true);
        this.captionPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.captionLabel = new JLabel(caption, icon, 10);
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1));
        this.captionLabel.setOpaque(false);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 6));
        this.captionPanel.add((Component)this.captionLabel, "West");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 16, 0);
        this.add((Component)this.captionPanel, constraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)Bundle.StopwatchCustomizer_NameLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 8, 10, 5);
        this.add((Component)this.nameLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, constraints);
        this.nameTextField = new JTextField(""){

            @Override
            public Dimension getPreferredSize() {
                return StopwatchCustomizer.this.getParent() instanceof JViewport ? this.getMinimumSize() : new Dimension(400, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 10, 13);
        this.add((Component)this.nameTextField, constraints);
        JPanel settingsHeaderContainer = new JPanel(new GridBagLayout());
        this.settingsHeaderLabel = new JLabel(Bundle.StopwatchCustomizer_SettingsLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        settingsHeaderContainer.add((Component)this.settingsHeaderLabel, constraints);
        this.settingsHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        settingsHeaderContainer.add((Component)this.settingsHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)settingsHeaderContainer, constraints);
        ButtonGroup measureRadiosGroup = new ButtonGroup();
        JPanel measureSettingsContainer = new JPanel(new GridBagLayout());
        this.measureLabel = new JLabel(Bundle.StopwatchCustomizer_MeasureLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 8);
        measureSettingsContainer.add((Component)this.measureLabel, constraints);
        this.measureTimestampRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.measureTimestampRadio, (String)Bundle.StopwatchCustomizer_TimestampRadioText());
        measureRadiosGroup.add(this.measureTimestampRadio);
        this.measureTimestampRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 3);
        measureSettingsContainer.add((Component)this.measureTimestampRadio, constraints);
        this.measureTimestampDurationRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.measureTimestampDurationRadio, (String)Bundle.StopwatchCustomizer_DurationRadioText());
        measureRadiosGroup.add(this.measureTimestampDurationRadio);
        this.measureTimestampDurationRadio.setSelected(true);
        this.measureTimestampDurationRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        measureSettingsContainer.add((Component)this.measureTimestampDurationRadio, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 20, 10, 13);
        this.add((Component)measureSettingsContainer, constraints);
        JPanel locationBeginHeaderContainer = new JPanel(new GridBagLayout());
        this.locationBeginHeaderLabel = new JLabel(Bundle.StopwatchCustomizer_BeginLocationLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        locationBeginHeaderContainer.add((Component)this.locationBeginHeaderLabel, constraints);
        this.locationBeginHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        locationBeginHeaderContainer.add((Component)this.locationBeginHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)locationBeginHeaderContainer, constraints);
        this.locationBeginCustomizer = new LocationCustomizer();
        this.locationBeginCustomizer.addValidityListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 20, 12, 13);
        this.add((Component)this.locationBeginCustomizer, constraints);
        JPanel locationEndHeaderContainer = new JPanel(new GridBagLayout());
        this.locationEndHeaderLabel = new JLabel(Bundle.StopwatchCustomizer_EndLocationLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        locationEndHeaderContainer.add((Component)this.locationEndHeaderLabel, constraints);
        this.locationEndHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        locationEndHeaderContainer.add((Component)this.locationEndHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)locationEndHeaderContainer, constraints);
        this.locationEndCustomizer = new LocationCustomizer();
        this.locationEndCustomizer.resetMnemonic();
        this.locationEndCustomizer.addValidityListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 20, 0, 13);
        this.add((Component)this.locationEndCustomizer, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 8;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StopwatchCustomizer main = new StopwatchCustomizer("Stopwatch", null);
        main.addValidityListener(new ValidityListener(){

            @Override
            public void validityChanged(boolean isValid) {
                System.err.println(">>> Validity changed to " + isValid);
            }
        });
        JFrame frame = new JFrame("Customize Profiling Point");
        frame.getContentPane().add(main);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
        int requiredCaptionAreaWidth = this.nameLabel.getPreferredSize().width - 12;
        int diffCaptionAreaWidth = this.getPreferredCaptionAreaWidth() - requiredCaptionAreaWidth;
        int normalizedCaptionAreaWidth = diffCaptionAreaWidth > 0 ? diffCaptionAreaWidth : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth, 0, 0));
        this.locationBeginCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
        this.locationEndCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.measureTimestampRadio) {
            this.updateValidity();
        }
        if (e.getSource() == this.measureTimestampDurationRadio) {
            boolean selected = this.measureTimestampDurationRadio.isSelected();
            this.locationEndCustomizer.setEnabled(selected);
            this.locationEndHeaderLabel.setEnabled(selected);
            this.locationEndHeaderSeparator.setEnabled(selected);
            CodeProfilingPoint.Location endLocation = this.getPPEndLocation();
            if (selected && endLocation != null && endLocation.getFile().trim().length() == 0) {
                CodeProfilingPoint.Location startLocation = this.getPPStartLocation();
                CodeProfilingPoint.Location newEndLocation = new CodeProfilingPoint.Location(startLocation.getFile(), startLocation.getLine() + 1, Integer.MAX_VALUE);
                this.locationEndCustomizer.setPPLocation(newEndLocation);
            }
            this.updateValidity();
        }
    }

    @Override
    public void validityChanged(boolean isValid) {
        this.updateValidity();
    }

    private boolean isNameEmpty() {
        return this.nameTextField.getText().trim().length() == 0;
    }

    private boolean areEndLocationSettingsValid() {
        return this.measureTimestampRadio.isSelected() || this.locationEndCustomizer.areSettingsValid();
    }

    private void updateValidity() {
        boolean isValid;
        boolean bl = isValid = !this.isNameEmpty() && this.locationBeginCustomizer.areSettingsValid() && this.areEndLocationSettingsValid();
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }
}

