/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Texture2D extends Resource {

	public Texture2D(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the attachment located at the path of the texture.
	 *
	 * @return attachment that holds the texture's image information.
	 * @throws Lib3MFException
	 */
	public Attachment getAttachment() throws Lib3MFException {
		Pointer bufferAttachment = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2d_getattachment.invokeInt(new java.lang.Object[]{mHandle, bufferAttachment}));
		Pointer valueAttachment = bufferAttachment.getPointer(0);
		Attachment attachment = null;
		if (valueAttachment == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Attachment was a null pointer");
		}
		attachment = mWrapper.PolymorphicFactory(valueAttachment, Attachment.class);
		return attachment;
	}

	/**
	 * Sets the texture's package path to the path of the attachment.
	 *
	 * @param attachment attachment that holds the texture's image information.
	 * @throws Lib3MFException
	 */
	public void setAttachment(Attachment attachment) throws Lib3MFException {
		Pointer attachmentHandle = null;
		if (attachment != null) {
			attachmentHandle = attachment.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Attachment is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_texture2d_setattachment.invokeInt(new java.lang.Object[]{mHandle, attachmentHandle}));
	}

	/**
	 * Retrieves a texture's content type.
	 *
	 * @return returns content type enum.
	 * @throws Lib3MFException
	 */
	public Lib3MFWrapper.TextureType getContentType() throws Lib3MFException {
		Pointer bufferContentType = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2d_getcontenttype.invokeInt(new java.lang.Object[]{mHandle, bufferContentType}));
		return Lib3MFWrapper.EnumConversion.convertConstToTextureType(bufferContentType.getInt(0));
	}

	/**
	 * Retrieves a texture's content type.
	 *
	 * @param contentType new Content Type
	 * @throws Lib3MFException
	 */
	public void setContentType(Lib3MFWrapper.TextureType contentType) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_texture2d_setcontenttype.invokeInt(new java.lang.Object[]{mHandle, Lib3MFWrapper.EnumConversion.convertTextureTypeToConst(contentType)}));
	}

	/**
	 * Retrieves a texture's tilestyle type.
	 *
	 * @return GetTileStyleUV Result Tuple
	 * @throws Lib3MFException
	 */
	public GetTileStyleUVResult getTileStyleUV() throws Lib3MFException {
		Pointer bufferTileStyleU = new Memory(4);
		Pointer bufferTileStyleV = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2d_gettilestyleuv.invokeInt(new java.lang.Object[]{mHandle, bufferTileStyleU, bufferTileStyleV}));
		GetTileStyleUVResult returnTuple = new GetTileStyleUVResult();
		returnTuple.TileStyleU = Lib3MFWrapper.EnumConversion.convertConstToTextureTileStyle(bufferTileStyleU.getInt(0));
		returnTuple.TileStyleV = Lib3MFWrapper.EnumConversion.convertConstToTextureTileStyle(bufferTileStyleV.getInt(0));
		return returnTuple;
	}

	public static class GetTileStyleUVResult {
		/**
		 * returns tilestyle type enum.
		 */
		public Lib3MFWrapper.TextureTileStyle TileStyleU;

		/**
		 * returns tilestyle type enum.
		 */
		public Lib3MFWrapper.TextureTileStyle TileStyleV;

	}
	/**
	 * Sets a texture's tilestyle type.
	 *
	 * @param tileStyleU new tilestyle type enum.
	 * @param tileStyleV new tilestyle type enum.
	 * @throws Lib3MFException
	 */
	public void setTileStyleUV(Lib3MFWrapper.TextureTileStyle tileStyleU, Lib3MFWrapper.TextureTileStyle tileStyleV) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_texture2d_settilestyleuv.invokeInt(new java.lang.Object[]{mHandle, Lib3MFWrapper.EnumConversion.convertTextureTileStyleToConst(tileStyleU), Lib3MFWrapper.EnumConversion.convertTextureTileStyleToConst(tileStyleV)}));
	}

	/**
	 * Retrieves a texture's filter type.
	 *
	 * @return returns filter type enum.
	 * @throws Lib3MFException
	 */
	public Lib3MFWrapper.TextureFilter getFilter() throws Lib3MFException {
		Pointer bufferFilter = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_texture2d_getfilter.invokeInt(new java.lang.Object[]{mHandle, bufferFilter}));
		return Lib3MFWrapper.EnumConversion.convertConstToTextureFilter(bufferFilter.getInt(0));
	}

	/**
	 * Sets a texture's filter type.
	 *
	 * @param filter sets new filter type enum.
	 * @throws Lib3MFException
	 */
	public void setFilter(Lib3MFWrapper.TextureFilter filter) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_texture2d_setfilter.invokeInt(new java.lang.Object[]{mHandle, Lib3MFWrapper.EnumConversion.convertTextureFilterToConst(filter)}));
	}


}

