﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appconfig/AppConfig_EXPORTS.h>
#include <aws/appconfig/model/ValidatorType.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppConfig {
namespace Model {

/**
 * <p>A summary of a configuration profile.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/ConfigurationProfileSummary">AWS
 * API Reference</a></p>
 */
class ConfigurationProfileSummary {
 public:
  AWS_APPCONFIG_API ConfigurationProfileSummary() = default;
  AWS_APPCONFIG_API ConfigurationProfileSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPCONFIG_API ConfigurationProfileSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPCONFIG_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The application ID.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  ConfigurationProfileSummary& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the configuration profile.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  ConfigurationProfileSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the configuration profile.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ConfigurationProfileSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URI location of the configuration.</p>
   */
  inline const Aws::String& GetLocationUri() const { return m_locationUri; }
  inline bool LocationUriHasBeenSet() const { return m_locationUriHasBeenSet; }
  template <typename LocationUriT = Aws::String>
  void SetLocationUri(LocationUriT&& value) {
    m_locationUriHasBeenSet = true;
    m_locationUri = std::forward<LocationUriT>(value);
  }
  template <typename LocationUriT = Aws::String>
  ConfigurationProfileSummary& WithLocationUri(LocationUriT&& value) {
    SetLocationUri(std::forward<LocationUriT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The types of validators in the configuration profile.</p>
   */
  inline const Aws::Vector<ValidatorType>& GetValidatorTypes() const { return m_validatorTypes; }
  inline bool ValidatorTypesHasBeenSet() const { return m_validatorTypesHasBeenSet; }
  template <typename ValidatorTypesT = Aws::Vector<ValidatorType>>
  void SetValidatorTypes(ValidatorTypesT&& value) {
    m_validatorTypesHasBeenSet = true;
    m_validatorTypes = std::forward<ValidatorTypesT>(value);
  }
  template <typename ValidatorTypesT = Aws::Vector<ValidatorType>>
  ConfigurationProfileSummary& WithValidatorTypes(ValidatorTypesT&& value) {
    SetValidatorTypes(std::forward<ValidatorTypesT>(value));
    return *this;
  }
  inline ConfigurationProfileSummary& AddValidatorTypes(ValidatorType value) {
    m_validatorTypesHasBeenSet = true;
    m_validatorTypes.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of configurations contained in the profile. AppConfig supports
   * <code>feature flags</code> and <code>freeform</code> configurations. We
   * recommend you create feature flag configurations to enable or disable new
   * features and freeform configurations to distribute configurations to an
   * application. When calling this API, enter one of the following values for
   * <code>Type</code>:</p> <p> <code>AWS.AppConfig.FeatureFlags</code> </p> <p>
   * <code>AWS.Freeform</code> </p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  ConfigurationProfileSummary& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;

  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_locationUri;

  Aws::Vector<ValidatorType> m_validatorTypes;

  Aws::String m_type;
  bool m_applicationIdHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_locationUriHasBeenSet = false;
  bool m_validatorTypesHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppConfig
}  // namespace Aws
