/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.SolrConfigHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final SolrQueryRequest req;
    ManagedIndexSchema managedIndexSchema;
    int updateTimeOut;

    public SchemaManager(SolrQueryRequest req) {
        this.req = req;
        int defaultUpdateTimeOut = Integer.getInteger("solr.schemaUpdateTimeoutSeconds", 600);
        this.updateTimeOut = req.getParams().getInt("updateTimeoutSecs", defaultUpdateTimeOut);
        if (this.updateTimeOut < 1) {
            this.updateTimeOut = defaultUpdateTimeOut;
        }
    }

    public List<Map<String, Object>> performOperations() throws Exception {
        List<CommandOperation> ops = this.req.getCommands(false);
        List errs = CommandOperation.captureErrors(ops);
        if (!errs.isEmpty()) {
            return errs;
        }
        IndexSchema schema = this.req.getCore().getLatestSchema();
        if (schema instanceof ManagedIndexSchema && schema.isMutable()) {
            return this.doOperations(ops);
        }
        return Collections.singletonList(Collections.singletonMap("errorMessages", "schema is not editable"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private List<Map<String, Object>> doOperations(List<CommandOperation> operations) throws InterruptedException, IOException, KeeperException {
        TimeOut timeOut = new TimeOut(this.updateTimeOut, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        SolrCore core = this.req.getCore();
        String errorMsg = "Unable to persist managed schema. ";
        List<Map<String, CallSite>> errors = Collections.emptyList();
        int latestVersion = -1;
        Object object = this.req.getSchema().getSchemaUpdateLock();
        // MONITORENTER : object
        while (!timeOut.hasTimedOut()) {
            this.managedIndexSchema = this.getFreshManagedSchema(this.req.getCore());
            for (CommandOperation op : operations) {
                OpType opType = OpType.get(op.name);
                if (opType != null) {
                    opType.perform(op, this);
                    continue;
                }
                op.addError("No such operation : " + op.name);
            }
            errors = CommandOperation.captureErrors(operations);
            if (!errors.isEmpty()) break;
            SolrResourceLoader loader = this.req.getCore().getResourceLoader();
            if (loader instanceof ZkSolrResourceLoader) {
                ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)loader;
                StringWriter sw = new StringWriter();
                try {
                    this.managedIndexSchema.persist(sw);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "unable to serialize schema");
                }
                try {
                    SolrConfigHandler configHandler = (SolrConfigHandler)this.req.getCore().getRequestHandler("/config");
                    if (configHandler.getReloadLock().tryLock()) {
                        try {
                            latestVersion = ZkController.persistConfigResourceToZooKeeper(zkLoader, this.managedIndexSchema.getSchemaZkVersion(), this.managedIndexSchema.getResourceName(), sw.toString().getBytes(StandardCharsets.UTF_8), true);
                            this.req.getCore().getCoreContainer().reload(this.req.getCore().getName(), this.req.getCore().uniqueId);
                            break;
                        }
                        finally {
                            configHandler.getReloadLock().unlock();
                        }
                    }
                    log.info("Another reload is in progress. Not doing anything.");
                }
                catch (ZkController.ResourceModifiedInZkException e) {
                    log.info("Schema was modified by another node. Retrying..");
                }
                continue;
            }
            try {
                this.managedIndexSchema.persistManagedSchema(false);
                core.setLatestSchema(this.managedIndexSchema);
                core.getCoreContainer().reload(core.getName(), core.uniqueId);
            }
            catch (SolrException e) {
                log.warn(errorMsg);
                errors = Collections.singletonList(Collections.singletonMap("errorMessages", errorMsg + e.getMessage()));
                break;
            }
        }
        // MONITOREXIT : object
        if (this.req.getCore().getResourceLoader() instanceof ZkSolrResourceLoader) {
            this.waitForOtherReplicasToUpdate(timeOut, latestVersion);
        }
        if (!errors.isEmpty()) return errors;
        if (!timeOut.hasTimedOut()) return errors;
        log.warn("{} Timed out", (Object)errorMsg);
        return Collections.singletonList(Collections.singletonMap("errorMessages", errorMsg + "Timed out."));
    }

    private void waitForOtherReplicasToUpdate(TimeOut timeOut, int latestVersion) {
        SolrCore core = this.req.getCore();
        CoreDescriptor cd = core.getCoreDescriptor();
        String collection = cd.getCollectionName();
        if (collection != null) {
            if (timeOut.hasTimedOut()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Not enough time left to update replicas. However, the schema is updated already.");
            }
            ManagedIndexSchema.waitForSchemaZkVersionAgreement(collection, cd.getCloudDescriptor().getCoreNodeName(), latestVersion, core.getCoreContainer().getZkController(), (int)timeOut.timeLeft(TimeUnit.SECONDS));
        }
    }

    public static String getErrorStr(Exception e) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = e;
        for (int i = 0; i < 5; ++i) {
            sb.append(cause.getMessage()).append("\n");
            if (cause.getCause() == null || cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return sb.toString();
    }

    private ManagedIndexSchema getFreshManagedSchema(SolrCore core) throws IOException, KeeperException, InterruptedException {
        SolrResourceLoader resourceLoader = core.getResourceLoader();
        Object schemaResourceName = core.getLatestSchema().getResourceName();
        if (resourceLoader instanceof ZkSolrResourceLoader) {
            ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)resourceLoader;
            SolrZkClient zkClient = zkLoader.getZkController().getZkClient();
            String managedSchemaPath = zkLoader.getConfigSetZkPath() + "/" + (String)schemaResourceName;
            try {
                if (!zkClient.exists(managedSchemaPath, true).booleanValue()) {
                    String backupName = (String)schemaResourceName + ".bak";
                    if (!zkClient.exists(zkLoader.getConfigSetZkPath() + "/" + backupName, true).booleanValue()) {
                        log.warn("Unable to retrieve fresh managed schema, neither {} nor {} exist.", schemaResourceName, (Object)backupName);
                        return (ManagedIndexSchema)core.getLatestSchema();
                    }
                    schemaResourceName = backupName;
                }
            }
            catch (Exception e) {
                log.warn("Unable to retrieve fresh managed schema {}", schemaResourceName, (Object)e);
                return (ManagedIndexSchema)core.getLatestSchema();
            }
            schemaResourceName = managedSchemaPath.substring(managedSchemaPath.lastIndexOf(47) + 1);
            InputStream in = resourceLoader.openResource((String)schemaResourceName);
            if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                int version = ((ZkSolrResourceLoader.ZkByteArrayInputStream)in).getStat().getVersion();
                log.info("managed schema loaded . version : {} ", (Object)version);
                return new ManagedIndexSchema(core.getSolrConfig(), (String)schemaResourceName, () -> IndexSchemaFactory.getParsedSchema(in, zkLoader, core.getLatestSchema().getResourceName()), true, (String)schemaResourceName, version, core.getLatestSchema().getSchemaUpdateLock());
            }
            return (ManagedIndexSchema)core.getLatestSchema();
        }
        return (ManagedIndexSchema)core.getLatestSchema();
    }

    public static enum OpType {
        ADD_FIELD_TYPE("add-field-type"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String className = op.getStr("class");
                if (op.hasError()) {
                    return false;
                }
                try {
                    FieldType fieldType = mgr.managedIndexSchema.newFieldType(name, className, op.getDataMap());
                    mgr.managedIndexSchema = mgr.managedIndexSchema.addFieldTypes((List)Collections.singletonList(fieldType), false);
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not add field type.", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        ADD_COPY_FIELD("add-copy-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String src = op.getStr("source");
                List dests = op.getStrs("dest");
                int maxChars = 0;
                String maxCharsStr = op.getStr("maxChars", null);
                if (null != maxCharsStr) {
                    try {
                        maxChars = Integer.parseInt(maxCharsStr);
                    }
                    catch (NumberFormatException e) {
                        op.addError("Exception parsing maxChars '" + maxCharsStr + "': " + SchemaManager.getErrorStr(e));
                    }
                    if (maxChars < 0) {
                        op.addError("maxChars '" + maxCharsStr + "' is negative.");
                    }
                }
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding(new String[]{"source", "dest", "maxChars"}).isEmpty()) {
                    op.addError("Only the 'source', 'dest' and 'maxChars' params are allowed with the 'add-copy-field' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.addCopyFields(src, (Collection)dests, maxChars);
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not add copy field", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        ADD_FIELD("add-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String type = op.getStr("type");
                if (op.hasError()) {
                    return false;
                }
                try {
                    SchemaField field = mgr.managedIndexSchema.newField(name, type, op.getValuesExcluding(new String[]{"name", "type"}));
                    mgr.managedIndexSchema = mgr.managedIndexSchema.addFields(Collections.singletonList(field), Collections.emptyMap(), false);
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not add field", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        ADD_DYNAMIC_FIELD("add-dynamic-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String type = op.getStr("type");
                if (op.hasError()) {
                    return false;
                }
                try {
                    SchemaField field = mgr.managedIndexSchema.newDynamicField(name, type, op.getValuesExcluding(new String[]{"name", "type"}));
                    mgr.managedIndexSchema = mgr.managedIndexSchema.addDynamicFields(Collections.singletonList(field), Collections.emptyMap(), false);
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not add dynamic field", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        DELETE_FIELD_TYPE("delete-field-type"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding(new String[]{"name"}).isEmpty()) {
                    op.addError("Only the 'name' param is allowed with the 'delete-field-type' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.deleteFieldTypes(Collections.singleton(name));
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not delete field type", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        DELETE_COPY_FIELD("delete-copy-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String source = op.getStr("source");
                List dests = op.getStrs("dest");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding(new String[]{"source", "dest"}).isEmpty()) {
                    op.addError("Only the 'source' and 'dest' params are allowed with the 'delete-copy-field' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.deleteCopyFields(Collections.singletonMap(source, dests));
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not delete copy field", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        DELETE_FIELD("delete-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding(new String[]{"name"}).isEmpty()) {
                    op.addError("Only the 'name' param is allowed with the 'delete-field' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.deleteFields(Collections.singleton(name));
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not delete field", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        DELETE_DYNAMIC_FIELD("delete-dynamic-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding(new String[]{"name"}).isEmpty()) {
                    op.addError("Only the 'name' param is allowed with the 'delete-dynamic-field' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.deleteDynamicFields(Collections.singleton(name));
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not delete dynamic field", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        REPLACE_FIELD_TYPE("replace-field-type"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String className = op.getStr("class");
                if (op.hasError()) {
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.replaceFieldType(name, className, op.getDataMap());
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not replace field type", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        REPLACE_FIELD("replace-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String type = op.getStr("type");
                if (op.hasError()) {
                    return false;
                }
                FieldType ft = mgr.managedIndexSchema.getFieldTypeByName(type);
                if (ft == null) {
                    op.addError("No such field type '" + type + "'");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.replaceField(name, ft, op.getValuesExcluding(new String[]{"name", "type"}));
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not replace field", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        REPLACE_DYNAMIC_FIELD("replace-dynamic-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String type = op.getStr("type");
                if (op.hasError()) {
                    return false;
                }
                FieldType ft = mgr.managedIndexSchema.getFieldTypeByName(type);
                if (ft == null) {
                    op.addError("No such field type '" + type + "'");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.replaceDynamicField(name, ft, op.getValuesExcluding(new String[]{"name", "type"}));
                    return true;
                }
                catch (Exception e) {
                    log.error("Could not replace dynamic field", (Throwable)e);
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        };


        public abstract boolean perform(CommandOperation var1, SchemaManager var2);

        public static OpType get(String label) {
            return Nested.OP_TYPES.get(label);
        }

        private OpType(String label) {
            Nested.OP_TYPES.put(label, this);
        }

        private static class Nested {
            static final Map<String, OpType> OP_TYPES = new HashMap<String, OpType>();

            private Nested() {
            }
        }
    }
}

