/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.Map;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.tracing.TraceUtils;

public abstract class AdminAPIBase
extends JerseyResource {
    protected final CoreContainer coreContainer;
    protected final SolrQueryRequest solrQueryRequest;
    protected final SolrQueryResponse solrQueryResponse;

    public AdminAPIBase(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        this.coreContainer = coreContainer;
        this.solrQueryRequest = solrQueryRequest;
        this.solrQueryResponse = solrQueryResponse;
    }

    protected CoreContainer fetchAndValidateZooKeeperAwareCoreContainer() {
        AdminAPIBase.validateZooKeeperAwareCoreContainer(this.coreContainer);
        return this.coreContainer;
    }

    protected String resolveAndValidateAliasIfEnabled(String unresolvedCollectionName, boolean aliasResolutionEnabled) {
        String resolvedCollectionName = aliasResolutionEnabled ? this.resolveAlias(unresolvedCollectionName) : unresolvedCollectionName;
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        if (!clusterState.hasCollection(resolvedCollectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + resolvedCollectionName + "' does not exist, no action taken.");
        }
        return resolvedCollectionName;
    }

    private String resolveAlias(String aliasName) {
        return this.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(aliasName);
    }

    public static void validateZooKeeperAwareCoreContainer(CoreContainer coreContainer) {
        if (coreContainer == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
    }

    protected String resolveCollectionName(String collName, boolean followAliases) {
        String collectionName = followAliases ? this.coreContainer.getZkController().getZkStateReader().getAliases().resolveSimpleAlias(collName) : collName;
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        if (!clusterState.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' does not exist, no action taken.");
        }
        return collectionName;
    }

    public static void recordCollectionForLogAndTracing(String collection, SolrQueryRequest solrQueryRequest) {
        MDCLoggingContext.setCollection(collection);
        TraceUtils.setDbInstance(solrQueryRequest, collection);
    }

    public void disableResponseCaching() {
        this.solrQueryResponse.setHttpCaching(false);
    }

    protected SolrResponse submitRemoteMessageAndHandleResponse(SubResponseAccumulatingJerseyResponse response, CollectionParams.CollectionAction action, ZkNodeProps remoteMessage, String asyncId) throws Exception {
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(this.coreContainer, this.coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, action, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        if (asyncId != null) {
            response.requestId = asyncId;
        }
        response.successfulSubResponsesByNodeName = remoteResponse.getResponse().get("success");
        response.failedSubResponsesByNodeName = remoteResponse.getResponse().get("failure");
        return remoteResponse;
    }

    protected static void insertIfNotNull(Map<String, Object> destination, String key, Object value) {
        if (value != null) {
            destination.put(key, value);
        }
    }
}

