/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup.repository;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.backup.repository.BackupRepository;

public abstract class AbstractBackupRepository
implements BackupRepository {
    public static final String PARAM_VERIFY_CHECKSUM = "verifyChecksum";
    protected NamedList<?> config;
    protected boolean shouldVerifyChecksum;

    @Override
    public void init(NamedList<?> args) {
        this.config = args;
        this.shouldVerifyChecksum = AbstractBackupRepository.getBooleanConfig(args, PARAM_VERIFY_CHECKSUM, true);
    }

    @Override
    public void copyIndexFileFrom(Directory sourceDir, String sourceFileName, Directory destDir, String destFileName) throws IOException {
        if (this.shouldVerifyChecksum) {
            BackupRepository.super.copyIndexFileFrom(sourceDir, sourceFileName, destDir, destFileName);
        } else {
            this.copyFileNoChecksum(sourceDir, sourceFileName, destDir, destFileName);
        }
    }

    protected static boolean getBooleanConfig(NamedList<?> args, String param, boolean defaultValue) {
        Object value = args.get(param);
        return value == null ? defaultValue : Boolean.parseBoolean(value.toString());
    }
}

