/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.maintenance;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.util.ReflectMapWriter;

public class InactiveShardRemoverConfig
implements ReflectMapWriter {
    public static final long DEFAULT_SCHEDULE_INTERVAL_SECONDS = 900L;
    public static final long DEFAULT_TTL_SECONDS = 900L;
    public static final int DEFAULT_MAX_DELETES_PER_CYCLE = 20;
    @JsonProperty
    public long scheduleIntervalSeconds;
    @JsonProperty
    public long ttlSeconds;
    @JsonProperty
    public int maxDeletesPerCycle;

    public InactiveShardRemoverConfig() {
        this(900L, 900L, 20);
    }

    public InactiveShardRemoverConfig(long scheduleIntervalSeconds, long ttlSeconds, int maxDeletesPerCycle) {
        this.scheduleIntervalSeconds = scheduleIntervalSeconds;
        this.ttlSeconds = ttlSeconds;
        this.maxDeletesPerCycle = maxDeletesPerCycle;
    }

    public void validate() {
        if (this.scheduleIntervalSeconds <= 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "scheduleIntervalSeconds must be greater than 0");
        }
        if (this.maxDeletesPerCycle <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "maxDeletesPerCycle must be greater than 0");
        }
    }
}

