/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.params.SolrParams;

public class MapSolrParams
extends SolrParams {
    protected final Map<String, String> map;

    public MapSolrParams(Map<String, String> map) {
        assert (map.entrySet().stream().allMatch(e -> {
            boolean hasStringKey = e.getKey() == null || ((String)e.getKey()).getClass() == String.class;
            boolean hasStringValue = e.getValue() == null || ((String)e.getValue()).getClass() == String.class;
            return hasStringKey && hasStringValue;
        }));
        this.map = map;
    }

    @Override
    public String get(String name) {
        return this.map.get(name);
    }

    @Override
    public String[] getParams(String name) {
        String[] stringArray;
        String val = this.map.get(name);
        if (val == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = val;
        }
        return stringArray;
    }

    @Override
    public Iterator<String> getParameterNamesIterator() {
        return this.map.keySet().iterator();
    }

    public Map<String, String> getMap() {
        return this.map;
    }
}

