/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.DomainObjectCollectionInternal;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.DefaultVariant;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.internal.DisplayName;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultConfigurationPublications
implements ConfigurationPublications {
    private final DisplayName displayName;
    private final PublishArtifactSetProvider allArtifacts;
    private final AttributeContainerInternal parentAttributes;
    private final ObjectFactory objectFactory;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final FileCollectionFactory fileCollectionFactory;
    private final AttributesFactory attributesFactory;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final TaskDependencyFactory taskDependencyFactory;
    private final PublishArtifactSet artifacts;
    private final AttributeContainerInternal attributes;
    private NamedDomainObjectContainer<ConfigurationVariant> variants;
    private DomainObjectSet<Capability> capabilities;
    private Supplier<String> observationReason;

    @Inject
    public DefaultConfigurationPublications(DisplayName displayName, PublishArtifactSet artifacts, PublishArtifactSetProvider allArtifacts, AttributeContainerInternal parentAttributes, ObjectFactory objectFactory, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, FileCollectionFactory fileCollectionFactory, AttributesFactory attributesFactory, DomainObjectCollectionFactory domainObjectCollectionFactory, TaskDependencyFactory taskDependencyFactory) {
        this.displayName = displayName;
        this.artifacts = artifacts;
        this.allArtifacts = allArtifacts;
        this.parentAttributes = parentAttributes;
        this.objectFactory = objectFactory;
        this.artifactNotationParser = artifactNotationParser;
        this.capabilityNotationParser = capabilityNotationParser;
        this.fileCollectionFactory = fileCollectionFactory;
        this.attributesFactory = attributesFactory;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.taskDependencyFactory = taskDependencyFactory;
        this.attributes = attributesFactory.mutable(parentAttributes);
    }

    public void collectVariants(ConfigurationInternal.VariantVisitor visitor) {
        PublishArtifactSet allArtifactSet = this.allArtifacts.getPublishArtifactSet();
        if (this.variants == null || this.variants.isEmpty() || !allArtifactSet.isEmpty()) {
            visitor.visitOwnVariant(this.displayName, this.attributes.asImmutable(), (Collection<? extends PublishArtifact>)allArtifactSet);
        }
        if (this.variants != null) {
            for (ConfigurationVariantInternal variant : this.variants.withType(ConfigurationVariantInternal.class)) {
                visitor.visitChildVariant(variant.getName(), variant.getDisplayName(), variant.getAttributes().asImmutable(), (Collection<? extends PublishArtifact>)variant.getArtifacts());
            }
        }
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public ConfigurationPublications attributes(Action<? super AttributeContainer> action) {
        action.execute((Object)this.attributes);
        return this;
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public void artifact(Object notation) {
        this.artifacts.add((Object)((PublishArtifact)this.artifactNotationParser.parseNotation(notation)));
    }

    public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        ConfigurablePublishArtifact publishArtifact = (ConfigurablePublishArtifact)this.artifactNotationParser.parseNotation(notation);
        this.artifacts.add((Object)publishArtifact);
        configureAction.execute((Object)publishArtifact);
    }

    public void artifacts(Provider<? extends Iterable<? extends Object>> provider) {
        this.artifacts.addAllLater(provider.map(iterable -> {
            ArrayList results = new ArrayList();
            iterable.forEach(notation -> results.add((PublishArtifact)this.artifactNotationParser.parseNotation(notation)));
            return results;
        }));
    }

    public void artifacts(Provider<? extends Iterable<? extends Object>> provider, Action<? super ConfigurablePublishArtifact> configureAction) {
        this.artifacts.addAllLater(provider.map(iterable -> {
            ArrayList results = new ArrayList();
            iterable.forEach(notation -> {
                ConfigurablePublishArtifact artifact = (ConfigurablePublishArtifact)this.artifactNotationParser.parseNotation(notation);
                configureAction.execute((Object)artifact);
                results.add(artifact);
            });
            return results;
        }));
    }

    public NamedDomainObjectContainer<ConfigurationVariant> getVariants() {
        if (this.variants == null) {
            this.variants = this.domainObjectCollectionFactory.newNamedDomainObjectContainer(ConfigurationVariant.class, this::createVariant);
            ((DomainObjectCollectionInternal)this.variants).beforeCollectionChanges(variantName -> {
                if (this.isObserved()) {
                    throw new InvalidUserCodeException("Cannot add secondary artifact set to " + this.displayName + " after " + this.observationReason.get() + ".");
                }
            });
        }
        return this.variants;
    }

    public void variants(Action<? super NamedDomainObjectContainer<ConfigurationVariant>> configureAction) {
        configureAction.execute(this.getVariants());
    }

    public void capability(Object notation) {
        if (this.isObserved()) {
            throw new InvalidUserCodeException("Cannot declare capability '" + notation + "' on " + this.displayName + " after " + this.observationReason.get() + ".");
        }
        if (this.capabilities == null) {
            this.capabilities = this.domainObjectCollectionFactory.newDomainObjectSet(Capability.class);
        }
        if (notation instanceof Provider) {
            this.capabilities.addLater(((Provider)notation).map(arg_0 -> this.capabilityNotationParser.parseNotation(arg_0)));
        } else {
            Capability descriptor = (Capability)this.capabilityNotationParser.parseNotation(notation);
            this.capabilities.add((Object)descriptor);
        }
    }

    public Collection<? extends Capability> getCapabilities() {
        return this.capabilities == null ? Collections.emptyList() : ImmutableList.copyOf(this.capabilities);
    }

    public void preventFromFurtherMutation(Supplier<String> observationReason) {
        this.observationReason = observationReason;
        if (this.variants != null) {
            for (ConfigurationVariant variant : this.variants) {
                ((ConfigurationVariantInternal)variant).preventFurtherMutation();
            }
        }
    }

    private boolean isObserved() {
        return this.observationReason != null;
    }

    private DefaultVariant createVariant(String name) {
        return (DefaultVariant)this.objectFactory.newInstance(DefaultVariant.class, new Object[]{this.displayName, name, this.parentAttributes, this.artifactNotationParser, this.fileCollectionFactory, this.attributesFactory, this.domainObjectCollectionFactory, this.taskDependencyFactory});
    }
}

