/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.EnumeratedType;

public class ExceptionSettings {
    public static final UnexpectedExceptionDisplay SHOW_EXCEPTION_PAGE = new UnexpectedExceptionDisplay("SHOW_EXCEPTION_PAGE");
    public static final UnexpectedExceptionDisplay SHOW_INTERNAL_ERROR_PAGE = new UnexpectedExceptionDisplay("SHOW_INTERNAL_ERROR_PAGE");
    public static final UnexpectedExceptionDisplay SHOW_NO_EXCEPTION_PAGE = new UnexpectedExceptionDisplay("SHOW_NO_EXCEPTION_PAGE");
    private UnexpectedExceptionDisplay unexpectedExceptionDisplay = SHOW_EXCEPTION_PAGE;
    private AjaxErrorStrategy errorHandlingStrategyDuringAjaxRequests = AjaxErrorStrategy.REDIRECT_TO_ERROR_PAGE;
    private ThreadDumpStrategy threadDumpStrategy = ThreadDumpStrategy.THREAD_HOLDING_LOCK;
    private NotRenderableErrorStrategy notRenderableErrorStrategy = NotRenderableErrorStrategy.LOG_WARNING;
    private boolean loudExceptionLogging = true;

    public UnexpectedExceptionDisplay getUnexpectedExceptionDisplay() {
        return this.unexpectedExceptionDisplay;
    }

    public ExceptionSettings setUnexpectedExceptionDisplay(UnexpectedExceptionDisplay unexpectedExceptionDisplay) {
        this.unexpectedExceptionDisplay = unexpectedExceptionDisplay;
        return this;
    }

    public AjaxErrorStrategy getAjaxErrorHandlingStrategy() {
        return this.errorHandlingStrategyDuringAjaxRequests;
    }

    public ExceptionSettings setAjaxErrorHandlingStrategy(AjaxErrorStrategy errorHandlingStrategyDuringAjaxRequests) {
        this.errorHandlingStrategyDuringAjaxRequests = errorHandlingStrategyDuringAjaxRequests;
        return this;
    }

    public ExceptionSettings setThreadDumpStrategy(ThreadDumpStrategy strategy) {
        this.threadDumpStrategy = (ThreadDumpStrategy)((Object)Args.notNull((Object)((Object)strategy), (String)"strategy"));
        return this;
    }

    public ThreadDumpStrategy getThreadDumpStrategy() {
        return this.threadDumpStrategy;
    }

    public NotRenderableErrorStrategy getNotRenderableErrorStrategy() {
        return this.notRenderableErrorStrategy;
    }

    public void setNotRenderableErrorStrategy(NotRenderableErrorStrategy notRenderableErrorStrategy) {
        this.notRenderableErrorStrategy = notRenderableErrorStrategy;
    }

    public ExceptionSettings setLoudExceptionLogging(boolean loudExceptionLogging) {
        this.loudExceptionLogging = loudExceptionLogging;
        return this;
    }

    public boolean isLoudExceptionLogging() {
        return this.loudExceptionLogging;
    }

    public static final class UnexpectedExceptionDisplay
    extends EnumeratedType {
        private static final long serialVersionUID = 1L;

        UnexpectedExceptionDisplay(String name) {
            super(name);
        }
    }

    public static enum AjaxErrorStrategy {
        REDIRECT_TO_ERROR_PAGE,
        INVOKE_FAILURE_HANDLER;

    }

    public static enum ThreadDumpStrategy {
        NO_THREADS,
        THREAD_HOLDING_LOCK,
        ALL_THREADS;

    }

    public static enum NotRenderableErrorStrategy {
        LOG_WARNING,
        THROW_EXCEPTION;

    }
}

